% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensionality_reduction_landmarked.R
\name{reduce_dimensionality_landmarked}
\alias{reduce_dimensionality_landmarked}
\title{Multidimensional scaling with landmarks}
\usage{
reduce_dimensionality_landmarked(x, dist_fun, ndim = 3,
  landmark_method = "naive", num_landmarks = 1000, rescale = T)
}
\arguments{
\item{x}{a numeric matrix}

\item{dist_fun}{the distance function to be used; must have exactly two arguments, namely dist_fun(x, y).}

\item{ndim}{the maximum dimension of the space which the data are to be represented in; must be in {1, 2, \ldots, n-1}.}

\item{landmark_method}{Must be "naive" for now. Other landmark methods will be supported in the future.}

\item{num_landmarks}{the number of landmarks to be selected.}

\item{rescale}{A logical indicating whether or not the returned space should be rescaled and centered.}
}
\value{
A list containing the reduced space of the landmarks and the complete dataset.
}
\description{
Multidimensional scaling with landmarks
}
\examples{
data(ginhoux)
space <- reduce_dimensionality_landmarked(
  ginhoux$expression,
  correlation_distance,
  num_landmarks = 200)
draw_trajectory_plot(space, ginhoux$sample_info$group_name)
}
