% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuneandtrainExtRF.R
\name{tuneandtrainExtRF}
\alias{tuneandtrainExtRF}
\title{Tune and Train External Random Forest}
\usage{
tuneandtrainExtRF(data, dataext, num.trees = 500)
}
\arguments{
\item{data}{A data frame containing the training data. The first column should be the response variable (factor), 
and the remaining columns should be the predictor variables.}

\item{dataext}{A data frame containing the external validation data. The first column should be the response 
variable (factor), and the remaining columns should be the predictor variables.}

\item{num.trees}{An integer specifying the number of trees in the Random Forest. Default is 500.}
}
\value{
A list containing the best `min.node.size` value(`best_min_node_size`), 
  the final trained model (`best_model`), and the AUC of the final model (`final_auc`).
}
\description{
This function tunes and trains a Random Forest classifier using the \code{ranger} package. The function 
evaluates a sequence of \code{min.node.size} values on an external validation dataset and selects 
the best model based on the Area Under the Curve (AUC).
}
\details{
Random Forest is an ensemble learning method that constructs multiple decision trees and aggregates their predictions. 
The \code{min.node.size} parameter controls the minimum number of samples in each terminal node, affecting model complexity. 
This function trains a Random Forest model on the training dataset and validates it using the external validation dataset. 
The \code{min.node.size} value that results in the highest AUC on the external validation dataset is chosen as the best model.
}
\examples{
\donttest{
# Load sample data
data(sample_data_train)
data(sample_data_extern)

# Example usage
result <- tuneandtrainExtRF(sample_data_train, sample_data_extern, num.trees = 500)
result$best_min_node_size
result$best_model
result$final_auc
}
}
