% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DCML.R
\name{cov.dcml}
\alias{cov.dcml}
\title{Approximate covariance matrix of the DCML regression estimator.}
\usage{
cov.dcml(res.LS, res.R, CC, sig.R, t0, p, n, control)
}
\arguments{
\item{res.LS}{vector of residuals from the least squares fit}

\item{res.R}{vector of residuals from the robust regression fit}

\item{CC}{estimated covariance matrix of the robust regression estimator}

\item{sig.R}{robust estimate of the scale of the residuals}

\item{t0}{mixing parameter}

\item{p, n}{the dimensions of the problem, needed for the finite
sample correction of the tuning constant of the M-scale}

\item{control}{a list of control parameters as returned by \code{\link{lmrobdet.control}}}
}
\value{
The covariance matrix estimate.
}
\description{
The estimated covariance matrix of the DCML regression estimator.
This function is used internally and not meant to be used
directly.
}
\author{
Victor Yohai, \email{victoryohai@gmail.com}
}
