% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QueryNamespace.R
\name{QueryNamespace}
\alias{QueryNamespace}
\title{QueryNamespace}
\description{
Given a results specification and ConnectionHandler instance - this class allow queries to be namespaced within
any tables specified within a list of pre-determined tables. This allows the encapsulation of queries, using specific
table names in a consistent manner that is striaghtforward to maintain over time.
}
\examples{

library(ResultModelManager)

# Create some junk test data
connectionDetails <-
  DatabaseConnector::createConnectionDetails(
    server = "test_db.sqlite",
    dbms = "sqlite"
  )

conn <- DatabaseConnector::connect(connectionDetails)
DatabaseConnector::insertTable(
  connection = conn,
  tableName = "cd_cohort",
  data = data.frame(
    cohort_id = c(1, 2, 3),
    cohort_name = c("cohort one", "cohort two", "cohort three"),
    json = "{}",
    sql = "SELECT 1"
  )
)
DatabaseConnector::disconnect(conn)

connectionHandler <- ConnectionHandler$new(connectionDetails = connectionDetails)
tableSpecification <- data.frame(
  tableName = "cohort",
  columnName = c(
    "cohort_id",
    "cohort_name",
    "json",
    "sql"
  ),
  primaryKey = c(TRUE, FALSE, FALSE, FALSE),
  dataType = c("int", "varchar", "varchar", "varchar")
)

cohortNamespace <- QueryNamespace$new(
  connectionHandler = connectionHandler,
  tableSpecification = tableSpecification,
  result_schema = "main",
  tablePrefix = "cd_"
)
sql <- "SELECT * FROM @result_schema.@cohort WHERE cohort_id = @cohort_id"
# Returns : "SELECT * FROM main.cd_cohort WHERE cohort_id = @cohort_id"
print(cohortNamespace$render(sql))
# Returns query result
result <- cohortNamespace$queryDb(sql, cohort_id = 1)
# cleanup test data
unlink("test_db.sqlite")
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{tablePrefix}}{tablePrefix to use}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-QueryNamespace-new}{\code{QueryNamespace$new()}}
\item \href{#method-QueryNamespace-setConnectionHandler}{\code{QueryNamespace$setConnectionHandler()}}
\item \href{#method-QueryNamespace-getConnectionHandler}{\code{QueryNamespace$getConnectionHandler()}}
\item \href{#method-QueryNamespace-addReplacementVariable}{\code{QueryNamespace$addReplacementVariable()}}
\item \href{#method-QueryNamespace-addTableSpecification}{\code{QueryNamespace$addTableSpecification()}}
\item \href{#method-QueryNamespace-render}{\code{QueryNamespace$render()}}
\item \href{#method-QueryNamespace-queryDb}{\code{QueryNamespace$queryDb()}}
\item \href{#method-QueryNamespace-executeSql}{\code{QueryNamespace$executeSql()}}
\item \href{#method-QueryNamespace-getVars}{\code{QueryNamespace$getVars()}}
\item \href{#method-QueryNamespace-finalize}{\code{QueryNamespace$finalize()}}
\item \href{#method-QueryNamespace-clone}{\code{QueryNamespace$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueryNamespace-new"></a>}}
\if{latex}{\out{\hypertarget{method-QueryNamespace-new}{}}}
\subsection{Method \code{new()}}{
initialize class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryNamespace$new(
  connectionHandler = NULL,
  tableSpecification = NULL,
  tablePrefix = "",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{connectionHandler}}{ConnectionHandler instance @seealso\link{ConnectionHandler}}

\item{\code{tableSpecification}}{tableSpecification data.frame}

\item{\code{tablePrefix}}{constant string to prefix all tables with}

\item{\code{...}}{additional replacement variables e.g. database_schema, vocabulary_schema etc
Set Connection Handler}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueryNamespace-setConnectionHandler"></a>}}
\if{latex}{\out{\hypertarget{method-QueryNamespace-setConnectionHandler}{}}}
\subsection{Method \code{setConnectionHandler()}}{
set connection handler object for object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryNamespace$setConnectionHandler(connectionHandler)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{connectionHandler}}{ConnectionHandler instance
Get connection handler}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueryNamespace-getConnectionHandler"></a>}}
\if{latex}{\out{\hypertarget{method-QueryNamespace-getConnectionHandler}{}}}
\subsection{Method \code{getConnectionHandler()}}{
get connection handler obeject or throw error if not set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryNamespace$getConnectionHandler()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueryNamespace-addReplacementVariable"></a>}}
\if{latex}{\out{\hypertarget{method-QueryNamespace-addReplacementVariable}{}}}
\subsection{Method \code{addReplacementVariable()}}{
add a variable to automatically be replaced in query strings (e.g. @database_schema.@table_name becomes 'database_schema.table_1')
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryNamespace$addReplacementVariable(key, value, replace = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{variable name string (without @) to be replaced, eg. "table_name"}

\item{\code{value}}{atomic value for replacement}

\item{\code{replace}}{if a variable of the same key is found, overwrite it
add table specification}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueryNamespace-addTableSpecification"></a>}}
\if{latex}{\out{\hypertarget{method-QueryNamespace-addTableSpecification}{}}}
\subsection{Method \code{addTableSpecification()}}{
add a variable to automatically be replaced in query strings (e.g. @database_schema.@table_name becomes
'database_schema.table_1')
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryNamespace$addTableSpecification(
  tableSpecification,
  useTablePrefix = TRUE,
  tablePrefix = self$tablePrefix,
  replace = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tableSpecification}}{table specification data.frame conforming to column names tableName, columnName, dataType and primaryKey}

\item{\code{useTablePrefix}}{prefix the results with the tablePrefix (TRUE)}

\item{\code{tablePrefix}}{prefix string - defaults to class variable set during initialization}

\item{\code{replace}}{replace existing variables of the same name
Render}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueryNamespace-render"></a>}}
\if{latex}{\out{\hypertarget{method-QueryNamespace-render}{}}}
\subsection{Method \code{render()}}{
Call to SqlRender::render replacing names stored in this class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryNamespace$render(sql, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sql}}{query string}

\item{\code{...}}{additional variables to be passed to SqlRender::render - will overwrite anything in namespace
query Sql}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueryNamespace-queryDb"></a>}}
\if{latex}{\out{\hypertarget{method-QueryNamespace-queryDb}{}}}
\subsection{Method \code{queryDb()}}{
Call to
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryNamespace$queryDb(sql, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sql}}{query string}

\item{\code{...}}{additional variables to send to SqlRender::render
execute Sql}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueryNamespace-executeSql"></a>}}
\if{latex}{\out{\hypertarget{method-QueryNamespace-executeSql}{}}}
\subsection{Method \code{executeSql()}}{
Call to execute sql within namespaced queries
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryNamespace$executeSql(sql, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sql}}{query string}

\item{\code{...}}{additional variables to send to SqlRender::render
get vars}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueryNamespace-getVars"></a>}}
\if{latex}{\out{\hypertarget{method-QueryNamespace-getVars}{}}}
\subsection{Method \code{getVars()}}{
returns full list of variables that will be replaced
Destruct object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryNamespace$getVars()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueryNamespace-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-QueryNamespace-finalize}{}}}
\subsection{Method \code{finalize()}}{
Close connections etc
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryNamespace$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueryNamespace-clone"></a>}}
\if{latex}{\out{\hypertarget{method-QueryNamespace-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryNamespace$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
