% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_features_in_pathway}
\alias{plot_features_in_pathway}
\alias{plot_KOs_in_pathway}
\title{Plot features trend in one pathway or module}
\usage{
plot_features_in_pathway(
  ko_stat,
  map_id = "map00780",
  modulelist = NULL,
  select_ko = NULL,
  box_color = reporter_color,
  show_number = TRUE,
  scale = FALSE,
  feature_type = "KOs",
  line_color = c(Depleted = "seagreen", Enriched = "orange", None = "grey", Significant =
    "red2")
)
}
\arguments{
\item{ko_stat}{ko_stat result from \code{\link{pvalue2zs}} or result of `get_reporter_score`}

\item{map_id}{the pathway or module id}

\item{modulelist}{NULL or customized modulelist dataframe, must contain "id","K_num","KOs","Description" columns. Take the `KOlist` as example, use \code{\link{custom_modulelist}}.}

\item{select_ko}{select which ko}

\item{box_color}{box and point color, default: c("#e31a1c","#1f78b4")}

\item{show_number}{show the numbers.}

\item{scale}{scale the data by row.}

\item{feature_type}{show in the title ,default: KOs}

\item{line_color}{line color, default: c("Depleted"="seagreen","Enriched"="orange","None"="grey")}
}
\value{
ggplot
}
\description{
Plot features trend in one pathway or module
}
\examples{
\donttest{
data("reporter_score_res")
plot_features_in_pathway(ko_stat = reporter_score_res, map_id = "map00860")
}
}
