% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{charToPOSIXct}
\alias{charToPOSIXct}
\title{Parse POSIXct objects from character variables}
\usage{
charToPOSIXct(sv, tz = "UTC")
}
\arguments{
\item{sv}{A vector of type character with datetime expressions
in ISO format to be parsed and converted.}

\item{tz}{A string with the timezone, defaults to \sQuote{UTC} if unset}
}
\value{
A vector of \sQuote{POSIXct} elements.
}
\description{
This function uses the Boost Date_Time library to parse 
datetimes from strings. It returns a vector of \code{POSIXct}
objects. These represent dates and time as (possibly
fractional) seconds since the \sQuote{epoch} of January 1, 1970. 
A timezone can be set, if none is supplied \sQuote{UTC} is set.
}
\details{
A single standard ISO format \sQuote{YYYY-MM-DD HH:MM:SS} (with
optional trailing fractional seconds) is tried.  In the case of
parsing failure a \code{NA} value is returned. See the function
\code{\link{toPOSIXct}} for more general input format

Fractional seconds are supported as well.  As R itself only supports 
microseconds, the Boost compile-time option for nano-second resolution 
has not been enabled.
}
\examples{
times <- c("2004-03-21 12:45:33.123456",
          "2004-03-21 12:45:34")
charToPOSIXct(times)
}
\author{
Dirk Eddelbuettel
}
