// -*- mode: C++; c-indent-level: 4; c-basic-offset: 4; tab-width: 4 -*-
//
// rhyper.h: Rcpp R/C++ interface class library -- 
//
// Copyright (C) 2010 - 2012 Douglas Bates, Dirk Eddelbuettel and Romain Francois
//
// This file is part of Rcpp.
//
// Rcpp is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// Rcpp is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Rcpp.  If not, see <http://www.gnu.org/licenses/>.

#ifndef Rcpp__stats__random_rhyper_h
#define Rcpp__stats__random_rhyper_h

namespace Rcpp {
    namespace stats {
        template <bool seed>
        class HyperGenerator : public Generator<seed,double>{
        public:
            HyperGenerator( double nn1_, double nn2_, double kk_) : 
                nn1(nn1_), nn2(nn2_), kk(kk_){}
            inline double operator()() const { return ::Rf_rhyper(nn1, nn2, kk) ;}  
        private:
            double nn1, nn2, kk ;
        } ;
    }
    
	// Please make sure you to read Section 6.3 of "Writing R Extensions"
	// about the need to call GetRNGstate() and PutRNGstate() when using 
	// the random number generators provided by R.
	inline NumericVector rhyper( int n, double nn1, double nn2, double kk ){
		return NumericVector( n, stats::HyperGenerator<false>( nn1, nn2, kk ) ) ;
	}

} // Rcpp

#endif
