% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-random-normal-walk-drift.R
\name{random_normal_drift_walk}
\alias{random_normal_drift_walk}
\title{Generate Multiple Random Walks with Drift}
\usage{
random_normal_drift_walk(
  .num_walks = 25,
  .n = 100,
  .mu = 0,
  .sd = 1,
  .drift = 0.1,
  .initial_value = 0,
  .dimensions = 1
)
}
\arguments{
\item{.num_walks}{Integer. The number of random walks to generate. Default is 25.}

\item{.n}{Integer. The number of steps in each random walk. Default is 100.}

\item{.mu}{Numeric. The mean of the normal distribution used for generating steps. Default is 0.}

\item{.sd}{Numeric. The standard deviation of the normal distribution used for generating steps. Default is 1.}

\item{.drift}{Numeric. The drift term to be added to each step. Default is 0.1.}

\item{.initial_value}{A numeric value indicating the initial value of the walks. Default is 0.}

\item{.dimensions}{The default is 1. Allowable values are 1, 2 and 3.}
}
\value{
A tibble containing the generated random walks with columns depending
on the number of dimensions:
\itemize{
\item \code{walk_number}: Factor representing the walk number.
\item \code{step_number}: Step index.
\item \code{y}: If \code{.dimensions = 1}, the value of the walk at each step.
\item \code{x}, \code{y}: If \code{.dimensions = 2}, the values of the walk in two dimensions.
\item \code{x}, \code{y}, \code{z}: If \code{.dimensions = 3}, the values of the walk in three dimensions.
}

The following are also returned based upon how many dimensions there are and
could be any of x, y and or z:
\itemize{
\item \code{cum_sum}: Cumulative sum of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_prod}: Cumulative product of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_min}: Cumulative minimum of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_max}: Cumulative maximum of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_mean}: Cumulative mean of \code{dplyr::all_of(.dimensions)}.
}
}
\description{
This function generates a specified number of random walks, each consisting
of a specified number of steps. The steps are generated from a normal
distribution with a given mean and standard deviation. An additional drift
term is added to each step to introduce a consistent directional component
to the walks.
}
\details{
This function generates multiple random walks with a specified drift.
Each walk is generated using a normal distribution for the steps, with an
additional drift term added to each step.
}
\examples{
set.seed(123)
random_normal_drift_walk()

set.seed(123)
random_normal_drift_walk(.dimensions = 3) |>
  head() |>
  t()

}
\seealso{
Other Generator Functions: 
\code{\link{brownian_motion}()},
\code{\link{discrete_walk}()},
\code{\link{geometric_brownian_motion}()},
\code{\link{random_normal_walk}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Generator Functions}
