/*
 * Decompiled with CFR 0.152.
 */
package nlcon;

import java.awt.EventQueue;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import nlcon.NLResult;
import org.nlogo.api.CompilerException;
import org.nlogo.api.LogoException;
import org.nlogo.app.App;
import org.nlogo.headless.HeadlessWorkspace;
import org.nlogo.util.Exceptions;
import org.nlogo.workspace.Controllable;

public class NLink_v4 {
    private Controllable workspace = null;
    private IOException caughtEx = null;
    private boolean isGUIworkspace;
    private static boolean blockExit = true;
    private String userdir;
    static final SecurityManager securityManager1 = new SecurityManager(){

        public void checkPermission(Permission permission) {
            if (blockExit && "exitVM".equals(permission.getName())) {
                JOptionPane.showMessageDialog(null, "system.exit attemted and blocked.", "Error", 2);
                throw new SecurityException("System.exit attempted and blocked.");
            }
        }

        public void checkExit(int status) {
            if (blockExit) {
                JOptionPane.showMessageDialog(null, "Please use NLQuit() for closing the window.", "Error", 2);
                throw new SecurityException("Preventing sub-tool from calling System.exit(" + Integer.toString(status) + ")!");
            }
        }
    };

    public void KillWorkspace() {
        try {
            blockExit = false;
            if (this.isGUIworkspace) {
                ((App)this.workspace).frame.dispose();
                Thread.currentThread().interrupt();
            } else {
                ((HeadlessWorkspace)this.workspace).dispose();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Error in killing workspace:" + ex, "Error", 2);
        }
        this.workspace = null;
        System.gc();
        if (this.userdir.length() > 0) {
            System.setProperty("user.dir", this.userdir);
        }
    }

    public NLink_v4(Boolean isGUImode, String _userdir) {
        this.userdir = _userdir;
        try {
            System.setSecurityManager(securityManager1);
            this.isGUIworkspace = isGUImode;
            if (this.isGUIworkspace) {
                App.main((String[])new String[0]);
                this.workspace = App.app;
                Exceptions.setHandler((Exceptions.Handler)new Exceptions.Handler(){

                    public void handle(Throwable t) {
                        throw new RuntimeException(t.getMessage());
                    }
                });
            } else {
                this.workspace = HeadlessWorkspace.newInstance();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Error in Constructor NLink:" + ex, "Error", 2);
        }
    }

    public void loadModel(final String path) throws IOException, LogoException, CompilerException, InterruptedException {
        this.caughtEx = null;
        if (this.isGUIworkspace) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        try {
                            App.app.open(path);
                        }
                        catch (IOException ex) {
                            NLink_v4.this.caughtEx = ex;
                        }
                    }
                });
            }
            catch (InvocationTargetException ex) {
                JOptionPane.showMessageDialog(null, "Error in loading model:" + ex, "Error", 2);
                throw new RuntimeException(ex.getMessage());
            }
            if (this.caughtEx != null) {
                throw this.caughtEx;
            }
        } else {
            try {
                if (this.workspace != null) {
                    ((HeadlessWorkspace)this.workspace).dispose();
                }
                this.workspace = HeadlessWorkspace.newInstance();
                this.workspace.open(path);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Error in loading model:" + ex, "Error", 2);
                if (this.workspace != null) {
                    ((HeadlessWorkspace)this.workspace).dispose();
                }
                this.workspace = HeadlessWorkspace.newInstance();
                throw ex;
            }
        }
    }

    public void sourceFromString(final String source, final Boolean addProcedure) throws IOException, LogoException, CompilerException, InterruptedException {
        this.caughtEx = null;
        if (this.isGUIworkspace) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        try {
                            if (addProcedure.booleanValue()) {
                                App.app.setProcedures(String.valueOf(App.app.getProcedures()) + "\n" + source);
                            } else {
                                App.app.setProcedures(source);
                            }
                            App.app.compile();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (InvocationTargetException ex) {
                JOptionPane.showMessageDialog(null, "Error in model from source:" + ex, "Error", 2);
                throw new RuntimeException(ex.getMessage());
            }
            if (this.caughtEx != null) {
                throw this.caughtEx;
            }
        }
    }

    public void command(String s) throws LogoException, CompilerException {
        this.workspace.command(s);
    }

    public void command(String[] s) throws LogoException, CompilerException {
        int i = 0;
        while (i < s.length) {
            this.workspace.command(s[i]);
            ++i;
        }
    }

    public void doCommand(String str, Integer iter) throws LogoException, CompilerException {
        int i = 0;
        while (i < iter) {
            this.workspace.command(str);
            ++i;
        }
    }

    public void doCommand(String[] s, Integer iter) throws LogoException, CompilerException {
        int i = 0;
        while (i < iter) {
            this.command(s);
            ++i;
        }
    }

    public void doCommandWhile(String s, String cond) throws LogoException, CompilerException {
        while (((Boolean)this.workspace.report(cond)).booleanValue()) {
            this.workspace.command(s);
        }
    }

    public void doCommandWhile(String[] s, String cond) throws LogoException, CompilerException {
        while (((Boolean)this.workspace.report(cond)).booleanValue()) {
            this.command(s);
        }
    }

    public Object report(String s) throws LogoException, CompilerException, Exception {
        NLResult result = new NLResult();
        result.setResultValue(this.workspace.report(s));
        return result;
    }

    public Object[] report(String[] s) throws LogoException, CompilerException, Exception {
        Object[] results = new Object[s.length];
        int i = 0;
        while (i < s.length) {
            NLResult result = new NLResult();
            result.setResultValue(this.workspace.report(s[i]));
            results[i] = result;
            ++i;
        }
        return results;
    }

    public Object[] doReport(String s, String var, Integer repeats) throws LogoException, CompilerException, Exception {
        Object[] results = new Object[repeats.intValue()];
        int i = 0;
        while (i < repeats) {
            this.workspace.command(s);
            results[i] = this.report(var);
            ++i;
        }
        return results;
    }

    public Object[] doReport(String s, String[] vars, Integer repeats) throws LogoException, CompilerException, Exception {
        Object[] results = new Object[repeats.intValue()];
        int i = 0;
        while (i < repeats) {
            this.workspace.command(s);
            results[i] = this.report(vars);
            ++i;
        }
        return results;
    }

    public Object[] doReportWhile(String s, String var, String condition) throws LogoException, CompilerException, Exception {
        ArrayList<Object> varList = new ArrayList<Object>();
        int i = 0;
        while (((Boolean)this.workspace.report(condition)).booleanValue()) {
            this.workspace.command(s);
            varList.add(this.report(var));
            ++i;
        }
        Object[] objArray = varList.toArray();
        return objArray;
    }

    public Object[] doReportWhile(String s, String[] vars, String condition) throws LogoException, CompilerException, Exception {
        ArrayList<Object[]> varList = new ArrayList<Object[]>();
        int i = 0;
        while (((Boolean)this.workspace.report(condition)).booleanValue()) {
            this.workspace.command(s);
            varList.add(this.report(vars));
            ++i;
        }
        Object[] objArray = varList.toArray();
        return objArray;
    }
}

