
##########################
## Lung data (X)
#############################
#' @description
#' This data set is a small subset of the full data set from GTEx.  It contains
#' RNA-seq expressions measured from lung tissue. The RNA-seq expressions have
#' been normalized with the TMM method.
#'
#' @name lung
#' @title RNA-seq expression from lung tissue (GTEx).
#' @docType data
#' @format a data frame with 221 rows and 100 variables (genes). Rownames are
#' identifiers for individuals.
#'
#' @source The raw data were download from \url{https://gtexportal.org/}.
#' The TMM normalisation of RNA-seq expression was performed with the R package
#' \code{edgeR}.
#'
#' @author Alyssa Imbert <alyssa.imbert@inra.fr>

NULL


##########################
## Thyroid data (Y)
#############################
#' @description
#' This data set is a small subset of the full data set from GTEx.  It contains
#' RNA-seq expressions measured from thyroid tissue. The RNA-seq expressions
#' have been normalized with the TMM method.
#'
#' @docType data
#' @title RNA-seq expression from thyroid tissue (GTEx).
#' @name thyroid
#' @format a data frame with 221 rows and 50 variables (genes). Rownames are
#' identifiers for individuals.
#'
#' @source The raw data were downloaded from \url{https://gtexportal.org/}. The
#' TMM normalisation of RNA-seq expression was performed with the R package
#' \code{edgeR}.
#' @author Alyssa Imbert <alyssa.imbert@inra.fr>

NULL
