% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modCloudMask.R
\name{modCloudMask}
\alias{modCloudMask}
\title{Create cloud masks for MODIS images}
\usage{
modCloudMask(src, AppRoot, out.name, overwrite = FALSE, ...)
}
\arguments{
\item{src}{the path to the folder with the MODIS with \code{state_1km} images.}

\item{AppRoot}{the directory where cloud masks are saved.}

\item{out.name}{the name of the folder that stores the outputs. 
If the arguemnt is not defined the folder will be named as "CloudMask".}

\item{overwrite}{logical argument. If \code{TRUE}, overwrites the existing
images with the same name.}

\item{...}{arguments for nested functions.
\itemize{
  \item \code{dates} a vector of dates being considered
  for creating cloud masks. This argument is optional.
}}
}
\value{
this function does not return anything. It saves the cloud masks (CLD)
as GTiff files in the \code{AppRoot} directory.
}
\description{
\code{modCloudMask} creates cloud masks derived from the State Quality
Assurance (State QA) band.
}
\details{
This function, interprets the State Quality Assurance (State QA) band to
create cloud masks. The \code{NA} and \code{1} values of the mask represent
cloudy and clear-sky pixels pixels respectively.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre
data(ex.navarre)
wdir <- file.path(tempdir(),"Path_for_downloading_folder")
print(wdir)

# search and download images from MODIS between
# 01-01-2018 and 03-01-2018 for the region of Navarre
modDownSearch(product = "MOD09GA",
            startDate = as.Date("01-01-2017", "\%d-\%m-\%Y"),
            endDate = as.Date("03-01-2017", "\%d-\%m-\%Y"),
            username = "username",
            password = "password",
            AppRoot = wdir,
            extract.tif = TRUE,
            collection = 6,
            extent = ex.navarre)
            
# assign src1 as the output folder for modMosaic
wdir.mod <- file.path(wdir, "Modis")
wdir.mod.tiles <- file.path(wdir.mod, "MOD09GA")
wdir.mod.tif <- file.path(wdir.mod.tiles, "tif")
# mosaic the MODIS images
modMosaic(wdir.mod.tif, # the input folder 
          AppRoot = wdir.mod.tiles, # the output folder 
          out.name = "Navarre", # creates Navarre folder in AppRoot
          gutils = TRUE,
          extent = ex.navarre)


wdir.mod.navarre <- file.path(wdir.mod.tiles, "Navarre")
# generate the cloud masks      
modCloudMask(src = wdir.mod.navarre,
             AppRoot = wdir.mod.tiles,
             overwrite = TRUE)
             
files.mod.cld <- file.path(wdir.mod.tiles,"CloudMask")
img.mod.cld <- stack(list.files(files.mod.cld, full.names=TRUE, pattern="CLD"))

# select b01
img.mod.navarre <- stack(list.files(wdir.mod.navarre, 
                                    full.names=TRUE, 
                                    recursive = TRUE, 
                                    pattern="b01_1"))

# project to 500m
img.mod.cld.500 <- projectRaster(img.mod.cld,img.mod.navarre)

# plot the cloud free b01 layer
spplot(img.mod.navarre*img.mod.cld.500)
}
}
