% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modFolderToVar.R
\name{modFolderToVar}
\alias{modFolderToVar}
\title{Compute a remote sensing index from a time series of MODIS multispectral 
images}
\usage{
modFolderToVar(src, AppRoot, fun, getStack = FALSE, overwrite = FALSE,
  verbose = FALSE, ...)
}
\arguments{
\item{src}{path to the folder with the MODIS multispectral images.}

\item{AppRoot}{the directory of the outcoming time series.}

\item{fun}{is a \code{function} that computes the remote sensing index.}

\item{getStack}{logical argument. If \code{TRUE}, returns the time series of
images as a \code{RasterStack}, otherwise the images are saved in the Hard
Drive Device (HDD).}

\item{overwrite}{logical argument. If \code{TRUE}, it overwrites the existing
images with the same name.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the 
running steps and warnings.}

\item{...}{arguments for nested functions.}
}
\description{
\code{modFolderToVar} computes a remote sensing index from the spectral bands
of a time series of MODIS images. The images are specified by the path to
the folder that stores the imagery (resulting from the \code{\link{modMosaic}} 
function). The function returns a \code{RasterStack} with a time series of 
images with the index.
}
\details{
The function requires the definition of the \code{src} and \code{fun} 
arguments. The \code{src} is usually the path resulting from 
\code{\link{modMosaic}}. The \code{fun} argument can be any function from
this package beginning with “var” (\code{\link{varNDVI}}, \code{\link{varEVI}},
etc.). Custom functions can also be implemented. If \code{fun = varRGB}, then
the argument \code{getStack} must be equal to \code{FALSE} and the 
red-gree-blue (RGB) images must be imported afterwards.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre
data(ex.navarre)
# main output directory
src <- paste0(tempdir(),"/Path_for_downloading_folder")
print(src)
# download MOD09 images
modDownload(product = "MOD09GA",
            startDate = as.Date("01-01-2018", "\%d-\%m-\%Y"),
            endDate = as.Date("03-01-2018", "\%d-\%m-\%Y"),
            username = "username",
            password = "password",
            AppRoot = src, # output folder for tif images
            extract.tif = TRUE, 
            collection = 6,
            extent = ex.navarre)
# assign src.mod as the output folder from modMosaic
src.mod <- file.path(src, "Modis", "MOD09GA") # output directory
src.tif <- file.path(src.mod, "tif") # input directory
# mosaic the MODIS images
modMosaic(src.tif,
          AppRoot = src.mod,
          out.name = "Navarre")
# path to the folder with the mosaicked images
src.navarre <- file.path(src.mod, "Navarre")
# generate NDVI images of Navarre
src.variables <- file.path(src.mod, "Variables")
dir.create(src.variables)
modFolderToVar(src = src.navarre,
               fun = varEVI,
               scfun = getRGISToolsOpt("MOD09SCL"),
               AppRoot = src.variables,
               overwrite = TRUE)
# import mosaicked images (.tif) to the environment in `R'
flist <- list.files(file.path(src.variables,"EVI"),
                    pattern = "\\\\.tif$",
                    full.names = TRUE,
                    recursive = TRUE)

files.raster <- lapply(flist,raster)
spplot(files.raster[[1]],at=seq(-1,2.5))
}
}
