% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsDownload.R
\name{lsDownload}
\alias{lsDownload}
\title{Search and download Landsat-7 or Landsat-8 images}
\usage{
lsDownload(satellite, startDate, endDate, username, password, AppRoot,
  lvl = 1, product = c("sr", "source_metadata"), verbose = FALSE,
  untar = TRUE, raw.rm = FALSE, ...)
}
\arguments{
\item{satellite}{string containing the type of satellite 
(\code{"ls7"} or \code{"ls8"}).}

\item{startDate}{a \code{Date} class object with the starting date of the 
study period.}

\item{endDate}{a \code{Date} class object with the ending date of the 
study period.}

\item{username}{USGS’s `EarthExplorer' username.}

\item{password}{USGS’s `EarthExplorer' password.}

\item{AppRoot}{the download directory.}

\item{lvl}{a number specifying the processing level. Default value, 1.}

\item{product}{\code{character} vector with the requested Level-2 products.
By default \code{c("sr", "source_metadata")}.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the
running steps and warnings.}

\item{untar}{logical argument. If \code{TRUE}, untars downloaded images.}

\item{raw.rm}{logical argument. If \code{TRUE}, removes the raw images.}

\item{...}{argumetns for nested functions:
 \itemize{
  \item any argument for \code{\link{ls8Search}}/\code{\link{ls7Search}} or 
  \code{\link{lsDownSearch}}.
}}
}
\value{
this function does not return anything. It saves the imagery as
`tar.gz’ (and GTiff files) in a folder called `raw’ (`untar’) in the
 \code{AppRoot} directory.
}
\description{
\code{lsDonwload} searches and downloads Landsat-7 or Landsat-8 images
concerning a particular location and time interval from the 
\href{https://earthexplorer.usgs.gov/}{`EarthExplorer' repository}.
Images are saved as GTiff files in the \code{AppRoot} directory.
}
\details{
\code{lsDonwload} is a wrapper function of \code{\link{ls7Search}}, 
\code{\link{ls8Search}}, and \code{\link{lsDownSearch}} to search and
download images in a single step. The function requires USGS's `EarthExplorer'
credentials, which can be obtained
\href{https://ers.cr.usgs.gov/register/}{here}.

The files from `EarthExplorer' are compressed as ‘tar.gz’. \code{lsDonwload}
decompresses the images and obtains the corresponding GTiffs. The GTiffs are
saved in the \code{AppRoot} directory. To change this option, provide 
\code{AppRoot = “full path”}. When the \code{untarDir} argument is defined,
the function untars the imagery in this location. Image decompression
duplicates the information due to the presence of both, compressed and 
decompressed images. Set \code{raw.rm = TRUE} to remove the former ones.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre
data(ex.navarre)

src <- paste0(tempdir(),"/Path_for_downloading_folder")
print(src)
# search and download the images from Landsat-8 between
# 01-01-2018 and 20-01-2018 for the region of Navarre
lsDownload(satellite = "ls8",
           username = "username",
           password = "password",
           startDate = as.Date("01-01-2018", "\%d-\%m-\%Y"),
           endDate = as.Date("20-01-2018", "\%d-\%m-\%Y"),
           extent = ex.navarre,
           AppRoot = src)
           
# remove metadata to free memory space
lsRemoveMetadata()
}
}
