% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction_model.v16.R
\name{plot_outputs}
\alias{plot_outputs}
\title{Plotting function}
\usage{
plot_outputs(
  curve = NULL,
  Time = NULL,
  cases = NULL,
  cfg = NULL,
  window_size = NULL,
  serial_mean,
  serial_var,
  predict.beyond = 0,
  waves_list = NULL,
  num_waves = NULL,
  rt_func = NULL,
  restrictions = NULL,
  restriction.starts = NULL,
  a1 = NULL,
  a2 = NULL,
  a3 = NULL,
  a4 = NULL,
  rt.max = NULL,
  option = "all",
  verbose = FALSE
)
}
\arguments{
\item{curve}{The output list from the prediction function, see \code{pred.curve}.}

\item{Time}{A vector of dates corresponding to cases.}

\item{cases}{A vector containing cases for each time point.}

\item{cfg}{The object that contains all variables from the configuration file.
\code{curve}, \code{Time}, and \code{cases} are also required
for the method to execute. All other parameters will not be used if \code{cfg} is passed to the method.}

\item{window_size}{The maximum value for the serial interval.}

\item{serial_mean}{Mean of the serial interval on the log scale.}

\item{serial_var}{Variance of the serial interval on the log scale.}

\item{predict.beyond}{How many days to predict beyond the end of \code{cases}.}

\item{waves_list}{A two-dimensional list containing the waves' time data.}

\item{num_waves}{Total number of waves.}

\item{rt_func}{A flag that indicates which rt function to use. Should match the shape of \code{curve}.}

\item{restrictions}{A numeric integer vector giving the severity of restrictions.}

\item{restriction.starts}{A vector of same length as restrictions, of times when restrictions
came into effect. Note: the first index time should be 1.}

\item{a1, a2, a3, a4}{Parameters of the contact rate curve specified by \code{rt_func}. These override
the values given in \code{curve} for the last plot only. If not specified, will use the values from \code{curve}.}

\item{rt.max}{An optional upper limit for the y-axis when plotting \eqn{R_t}.}

\item{option}{A choice of which plot to return (1,2, or 3 - see Value for options). If set to "all" (the default) plots all three figures.}

\item{verbose}{Logical. If TRUE, provides additional details while running the function.}
}
\value{
NULL. Generates a few plots: a plot of \eqn{R_t} over time, with waves shaded (for \code{option} = 1); the epidemic curve
overlaid on top of observed cases (\code{option} = 2), where the shading reflects restriction measures; and a plot of the
theoretical \eqn{R_t} versus \eqn{S_t}, in a fully susceptible population with no restrictions (\code{option} = 3).
}
\description{
Various plots related to an epidemic curve.
}
\examples{
library(REffectivePred)
## Read in the data
path_to_data <- system.file("extdata/NY_OCT_4_2022.csv", package = "REffectivePred")
data <- read.csv(path_to_data)
head(data)
cases <- diff(c(0, data$cases)) # Convert cumulative cases into daily cases
lt <- length(cases)             # Length of cases
Time <- as.Date(data$date, tryFormats = c("\%d-\%m-\%Y", "\%d/\%m/\%Y"))

navigate_to_config() # Open the config file, make any necessary changes here.
path_to_config <- system.file("config.yml", package = "REffectivePred")  # Read config file
cfg <- load_config()    # Build the cfg object

# Estimate parameters
est <- estimate.mle(
    cases = cases,
    cfg = cfg
    )
a1 <- est$a1
a2 <- est$a2
a3 <- est$a3
a4 <- est$a4
nu <- est$nu
vt <- c(1, est$vt_params_est)
psi <- est$Psi
betas <- est$betas

# Predict curve
r1 <- pred.curve(
a1 = a1,
a2 = a2,
a3 = a3,
a4 = a4,
nu = nu,
variant.transm = vt,
Psi = psi,
betas = betas,
cases = cases,
cfg = cfg
)

plot_outputs(Time = Time,
cases = cases,
window_size = cfg$window.size,
serial_mean = cfg$serial_mean,
serial_var = cfg$serial_var,
predict.beyond = cfg$predict.beyond,
waves_list = cfg$waves_list,
num_waves = cfg$num_waves,
rt_func = cfg$rt.func.num,
curve = r1,
restrictions = cfg$restrictions_params,
restriction.starts = cfg$restriction_st_params,
rt.max = 10
)
}
