% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bypqao.R
\name{aqs_qa_flowrateverification_by_pqao}
\alias{aqs_qa_flowrateverification_by_pqao}
\title{aqs_qa_flowrateverification_by_pqao}
\usage{
aqs_qa_flowrateverification_by_pqao(
  parameter,
  bdate,
  edate,
  pqao_code,
  cbdate = NA_Date_,
  cedate = NA_Date_,
  return_header = FALSE
)
}
\arguments{
\item{parameter}{a character list or a single character string
which represents the parameter code of the air
pollutant related to the data being requested.}

\item{bdate}{a R date object which represents that begin date of the data
selection. Only data on or after this date will be returned.}

\item{edate}{a R date object which represents that end date of the data
selection. Only data on or before this date will be returned.}

\item{pqao_code}{a R character object which represents the 4 digit AQS
Primary Quality Assurance Organization code
(with leading zeroes).}

\item{cbdate}{a R date object which represents a "beginning
date of last change" that indicates when the data was last
updated. cbdate is used to filter data based on the change
date. Only data that changed on or after this date will be
returned. This is an optional variable which defaults
to NA_Date_.}

\item{cedate}{a R date object which represents an "end
date of last change" that indicates when the data was last
updated. cedate is used to filter data based on the change
date. Only data that changed on or before this date will be
returned. This is an optional variable which defaults
to NA_Date_.}

\item{return_header}{If FALSE (default) only returns data requested. If TRUE
returns a AQSAPI_v2 object which is a two item list that contains header
information returned from the API server mostly used for debugging
purposes in addition to the data requested.}
}
\value{
a tibble or an AQS_Data Mart_APIv2 S3 object containing quality
assurance flow rate verification data for monitors within a pqao.
An AQS_Data Mart_APIv2 is a 2 item named list in which the first
item ($Header) is a tibble of header information from the AQS API
and the second item ($Data) is a tibble of the data returned.
}
\description{
\lifecycle{stable}
Returns a table containing flow rate Verification data for a
parameter code aggregated by matching input parameter, and
Primary Quality Assurance Organization (PQAO) code provided
for bdate - edate time.
}
\note{
The AQS API only allows for a single year of flow rate verifications to
be retrieved at a time. This function conveniently extracts date
information from the bdate and edate parameters then makes repeated
calls to the AQSAPI retrieving a maximum of one calendar year of data
at a time. Each calendar year of data requires a separate API call so
multiple years of data will require multiple API calls. As the number
of years of data being requested increases so does the length of time
that it will take to retrieve results. There is also a 5 second wait
time inserted between successive API calls to prevent overloading the
API server. This operation has a linear run time of
/(Big O notation: O/(n + 5 seconds/)/).
}
\examples{
# returns a tibble of flow rate verification
  #  data for January 2018 where the PQAO is the Alabama Department
  #  of Environmental Management (agency 0013)
  \dontrun{aqs_qa_flowrateverification_by_pqao(parameter = "88101",
                                               bdate = as.Date("20170101",
                                                            format = "\%Y\%m\%d"
                                                              ),
                                               edate = as.Date("20190131",
                                                            format = "\%Y\%m\%d"
                                                              ),
                                               pqao_code = "0013"
                                               )
         }
}
\seealso{
Other Aggregate _by_pqao functions: 
\code{\link{aqs_qa_annualpeferomanceeval_by_pqao}()},
\code{\link{aqs_qa_annualperformanceevaltransaction_by_pqao}()},
\code{\link{aqs_qa_blanks_by_pqao}()},
\code{\link{aqs_qa_collocated_assessments_by_pqao}()},
\code{\link{aqs_qa_flowrateaudit_by_pqao}()},
\code{\link{aqs_qa_one_point_qc_by_pqao}()},
\code{\link{aqs_qa_pep_audit_by_pqao}()}
}
\concept{Aggregate _by_pqao functions}
