% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc.cmpd.filter.blanks.R
\name{rc.cmpd.filter.blanks}
\alias{rc.cmpd.filter.blanks}
\title{rc.cmpd.filter.blanks}
\usage{
rc.cmpd.filter.blanks(
  ramclustObj = NULL,
  qc.tag = "QC",
  blank.tag = "blank",
  sn = 3,
  remove.blanks = TRUE
)
}
\arguments{
\item{ramclustObj}{ramclustObj containing SpecAbund dataframe.}

\item{qc.tag}{character vector of length one or two.  If length is two, enter search string and factor name in $phenoData slot (i.e. c("QC", "sample.type"). If length one (i.e. "QC"), will search for this string in the 'sample.names' slot by default.}

\item{blank.tag}{see 'qc.tag' , but for blanks to use as background.}

\item{sn}{numeric defines the ratio for 'signal'.  i.e. sn = 3 indicates that signal intensity must be 3 fold higher in sample than in blanks, on average, to be retained.}

\item{remove.blanks}{logical. TRUE by default.  this removes any recognized blanks samples from the SpecAbund sets after they are used to filter contaminant compounds}
}
\value{
ramclustR object with normalized data.
}
\description{
used to remove compounds which are found at similar intensity in blank samples.  Only applied after clustering.  see also rc.feature.filter.blanks for filtering at the feature level (only done before clustering).
}
\details{
This function removes compounds which contain signal in QC samples comparable to blanks.
}
\references{
Broeckling CD, Afsar FA, Neumann S, Ben-Hur A, Prenni JE. RAMClust: a novel feature clustering method enables spectral-matching-based annotation for metabolomics data. Anal Chem. 2014 Jul 15;86(14):6812-7. doi: 10.1021/ac501530d.  Epub 2014 Jun 26. PubMed PMID: 24927477.
}
\author{
Corey Broeckling
}
\concept{MSFinder}
\concept{RAMClustR}
\concept{clustering}
\concept{feature}
\concept{mass spectrometry}
\concept{metabolomics}
\concept{ramclustR}
\concept{xcms}
