% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSmilesInchi.R
\name{getSmilesInchi}
\alias{getSmilesInchi}
\title{getSmilesInchi}
\usage{
getSmilesInchi(ramclustObj = NULL)
}
\arguments{
\item{ramclustObj}{ramclustR object to ClassyFy}
}
\value{
returns a ramclustR object.  new dataframe in $classyfire slot with rows equal to number of compounds.
}
\description{
use PubChem API to look up full smiles and inchi notation for each inchikey
}
\details{
The $inchikey slot is used to look up parameters from pubchem. PubChem CID, a pubchem URL, smiles (canonical) and inchi are returned.  if smiles and inchi slots are alread present (from MSFinder, for example) pubchem smiles and inchi are used to fill in missing values only, not replace.
}
\references{
Kim S, Thiessen PA, Bolton EE, Bryant SH. PUG-SOAP and PUG-REST: web services for programmatic access to chemical information in PubChem. Nucleic Acids Res. 2015;43(W1):W605-11.
}
\author{
Corey Broeckling
}
\concept{MSFinder}
\concept{RAMClustR}
\concept{clustering}
\concept{feature}
\concept{inchi}
\concept{inchikey}
\concept{mass spectrometry}
\concept{metabolomics}
\concept{ramclustR}
\concept{smiles}
