% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.msfinder.structures.R
\name{import.msfinder.structures}
\alias{import.msfinder.structures}
\title{import.msfinder.structures}
\usage{
import.msfinder.structures(ramclustObj = NULL, mat.dir = NULL,
  msp.dir = NULL, msfinder.dir = "C:\\\\MSFinder\\\\MS-FINDER_2.20")
}
\arguments{
\item{ramclustObj}{R object - the ramclustR object which was used to write the .mat or .msp files}

\item{mat.dir}{optional path to .mat directory}

\item{msp.dir}{optional path to .msp directory}

\item{msfinder.dir}{path to directory containing msfinder program and 'resources' directory}
}
\value{
an annotated ramclustR object

ramclustR object with new $ slots for:

- msfinder.structure: data frame of one row describing the best structure match for the selected best formula match

- msfinder.structure$fragments:  data frame the fragment ion interpretations supporting the best structure match

- msfinder.structure$details: list containing the best structure match for all formulas.  Each list element represents one formula (with the formula as the name), and is composed of a list:

- structures: table of most likely structures

- fragments: list of data frames, with one element for each from from 'structures'.  names are assigned based on 'id' column from structures.
}
\description{
After running MSFinder on .mat or .msp files, import the structure that were predicted and their scores
}
\details{
this function imports the output from the MSFinder program to annotate the ramclustR object
}
\references{
Broeckling CD, Afsar FA, Neumann S, Ben-Hur A, Prenni JE. RAMClust: a novel feature clustering method enables spectral-matching-based annotation for metabolomics data. Anal Chem. 2014 Jul 15;86(14):6812-7. doi: 10.1021/ac501530d.  Epub 2014 Jun 26. PubMed PMID: 24927477.

Broeckling CD, Ganna A, Layer M, Brown K, Sutton B, Ingelsson E, Peers G, Prenni JE. Enabling Efficient and Confident Annotation of LC-MS Metabolomics Data through MS1 Spectrum and Time Prediction. Anal Chem. 2016 Sep 20;88(18):9226-34. doi: 10.1021/acs.analchem.6b02479. Epub 2016 Sep 8. PubMed PMID: 7560453.

Tsugawa H, Kind T, Nakabayashi R, Yukihira D, Tanaka W, Cajka T, Saito K, Fiehn O, Arita M. Hydrogen Rearrangement Rules: Computational MS/MS Fragmentation and Structure Elucidation Using MS-FINDER Software. Anal Chem. 2016 Aug 16;88(16):7946-58. doi: 10.1021/acs.analchem.6b00770. Epub 2016 Aug 4. PubMed PMID: 27419259.
}
\author{
Corey Broeckling
}
\keyword{'MSFinder'}
\keyword{'RAMClustR',}
\keyword{'clustering',}
\keyword{'feature',}
\keyword{'mass}
\keyword{'metabolomics',}
\keyword{'ramclustR'}
\keyword{'ramclustR',}
\keyword{'xcms',}
\keyword{spectrometry',}
