% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_rag_chain.R
\name{create_rag_chain}
\alias{create_rag_chain}
\title{create_rag_chain.R Overview}
\usage{
create_rag_chain(
  llm,
  vector_database_directory,
  method = "DuckDB",
  embedding_function = NULL,
  system_prompt = NULL,
  chat_history_prompt = NULL,
  tavily_search = NULL,
  embedding_dim = 1536,
  use_web_search = TRUE
)
}
\arguments{
\item{llm}{A function that takes a prompt and returns a response (e.g. a call to OpenAI or Claude).}

\item{vector_database_directory}{Path to DuckDB database file.}

\item{method}{Currently only "DuckDB" is supported.}

\item{embedding_function}{A function for embedding text. Defaults to `embed_openai()`.}

\item{system_prompt}{Optional prompt with placeholders \code{{chat_history}}, \code{{input}}, \code{{context}}}

\item{chat_history_prompt}{Prompt used to rephrase user questions based on prior context.}

\item{tavily_search}{API key for Tavily (or NULL to disable web search).}

\item{embedding_dim}{Dimensionality of embedding vectors (default 1536).}

\item{use_web_search}{Logical, whether to include web results from Tavily (default TRUE).}
}
\value{
A list of utility functions:
\itemize{
  \item \code{invoke(text)} — Performs full context retrieval + LLM response
  \item \code{custom_invoke(text)} — Retrieves context only, no LLM response
  \item \code{get_session_history()} — Returns full chat history
  \item \code{clear_history()} — Clears the chat memory
  \item \code{disconnect()} — Closes DuckDB connection
}
}
\description{
A refined implementation of a LangChain-style Retrieval-Augmented Generation (RAG) pipeline.
Includes vector search using DuckDB, optional web search using the Tavily API, and a
built-in chat message history.

This script powers `create_rag_chain()`, the exported entry point for constructing a RAG pipeline.

## Features:
- Context-aware reformulation of user questions based on chat history
- Retrieval of relevant chunks via semantic search
- Optional real-time web search using Tavily (if API key is set)
- Works with any LLM function (e.g., OpenAI, Claude)

## Required Packages
Install with:
\code{install.packages(c("DBI", "duckdb", "httr", "jsonlite", "stringi", "dplyr"))}

Creates a LangChain-style RAG chain using DuckDB for vector store operations, optional Tavily API for web search,
and in-memory message history for conversational context.
}
\note{
Only `create_rag_chain()` is exported.
}
