% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dts.R
\name{plot_dts}
\alias{plot_dts}
\title{Plot data.table time series}
\description{
Plot data.table time series
}
\section{Methods}{

\describe{
 \item{\bold{\code{plot_dts}}}{
 Add data to be plotted.
 }
 \item{\bold{\code{$lines}}}{
 Add lines with following arguments:
 \tabular{ll}{
    \code{names}                        \tab vector of column names to plot                        \cr
    \code{labels}                       \tab vector of labels if different from column names       \cr
    \code{type}                         \tab vector or single value, see \link[graphics]{lines}    \cr
    \code{lty,pch,col,lwd,lend}         \tab vector or single value, see \link[graphics]{par}      \cr
    \code{bg}                           \tab vector or single value, see \link[graphics]{points}   \cr
 }
 }
 \item{\bold{\code{$candles}}}{
 Add candles with following arguments:
    \tabular{ll}{
    \code{ohlc}                         \tab vector of open, high, low and close names             \cr
    \code{timeframe}                    \tab candle timeframe in minutes for intraday candles      \cr
    \code{position}                     \tab relative to time position only \code{'end'} supported \cr
    \code{type}                         \tab \code{'barchart'} or \code{'candlestick'}             \cr
    \code{gap}                          \tab gap between candles in fraction of \code{width}       \cr
    \code{mono}                         \tab should all candles have same color?                   \cr
    \code{col,col_up,col_flat,col_down} \tab colors                                                \cr
 }
 }
 \item{\bold{\code{$limits}}}{
 \tabular{ll}{
    \code{xlim}                         \tab vector of length two to limit plot area horizontally  \cr
    \code{ylim}                         \tab vector of length two to limit plot area vertically    \cr
    \code{tlim}                         \tab date or time vector of length two                     \cr
    \code{time_range}                   \tab intraday time limit in format 'H:M:S/H:M:S'           \cr
 }
 }
 \item{\bold{\code{$style}}}{
 Change default plot options. Available options are:
 \tabular{lll}{
    \bold{\code{grid}}\cr
    \code{minute}      \tab \code{list(col,lty)} \tab minute vertical gridline color and line type \cr
    \code{hour}        \tab \code{list(col,lty)} \tab hour vertical gridline color and line type   \cr
    \code{day}         \tab \code{list(col,lty)} \tab day vertical gridline color and line type    \cr
    \code{month}       \tab \code{list(col,lty)} \tab month vertical gridline color and line type  \cr
    \code{year}        \tab \code{list(col,lty)} \tab year vertical gridline color and line type   \cr
    \code{zero}        \tab \code{list(col,lty)} \tab zero horizontal gridline color and line type \cr
    \bold{\code{time}}\cr
    \code{grid}        \tab \code{logical}   \tab should vertical gridlines be plotted?                 \cr
    \code{resolution}  \tab \code{character} \tab auto, minute, hour, day, month, year or years         \cr
    \code{round}       \tab \code{numeric}   \tab time axis rounding in minutes                         \cr
    \code{visible}     \tab \code{logical}   \tab should time axis be plotted?                          \cr
    \bold{\code{value}}\cr
    \code{grid}        \tab \code{logical}  \tab should horizontal gridlines be plotted? \cr
    \code{last}        \tab \code{logical}  \tab should last values be plotted?          \cr
    \code{log}         \tab \code{logical}  \tab should y axis be in logarithmic scale?  \cr
    \code{visible}     \tab \code{logical}  \tab should y axis be plotted?               \cr
    \bold{\code{candle}}\cr
    \code{auto}          \tab \code{logical}                 \tab shoud candles be automatically detected and plotted?  \cr
    \code{col}           \tab \code{list(mono,up,flat,down)} \tab colors                                                \cr
    \code{gap}           \tab \code{numeric}                 \tab gap between candles in fraction of \code{width}       \cr
    \code{mono}          \tab \code{logical}                 \tab should all candles have same color?                   \cr
    \code{position}      \tab \code{character}               \tab relative to time position only \code{'end'} supported \cr
    \code{type}          \tab \code{character}               \tab \code{'candlestick'} or \code{'barchart'}             \cr
    \bold{\code{line}}\cr
    \code{auto}          \tab \code{logical}                 \tab shoud lines be automatically detected and plotted?    \cr
    \bold{\code{legend}}\cr
    \code{col}           \tab \code{list(background,frame)} \tab colors                       \cr
    \code{horizontal}    \tab \code{logical}                \tab should legend be horizontal? \cr
    \code{inset}         \tab \code{numeric}                \tab see \link[graphics]{legend}  \cr
    \code{position}      \tab \code{character}              \tab see \link[graphics]{legend}  \cr
    \code{visible}       \tab \code{logical}                \tab should legend be plotted?    \cr
 }
 }
}
}

