% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.qualint}
\alias{plot.qualint}
\title{Plot the interval based graph from a "qualint" object}
\usage{
\method{plot}{qualint}(x, ...)
}
\arguments{
\item{x}{a qualint object}

\item{...}{additional coef arguments}
}
\description{
Produce an interval based graph from an "qualint" object. Only available when
\code{test = "IBGA"}. Produce an error signal if \code{test = "LRT"}.
}
\details{
Differect scales are used here for different types of responses. For continous
one, the mean differece is plotted. For binary one, one from the risk difference,
relative risk or odds ratio will be plotted, depending on user's choice. For
survival responses, the hazard ratio is plotted.
}
\examples{
ynorm <- rnorm(300)
trtment <- sample(c(0, 1), 300, prob = c(0.4, 0.6),
                  replace = TRUE)
subgrp <- sample(c(0, 1, 2), 300, prob = c(1/3, 1/3, 1/3),
                 replace = TRUE)
test1 <- qualint(ynorm, trtment, subgrp)
plot(test1)
}
\author{
Lixi Yu, Eun-Young Suh, Guohua (James) Pan \cr
Maintainer: Lixi Yu \email{lixi-yu@uiowa.edu}
}
\references{
Gail and Simon (1985), Testing for qualitative interactions between
treatment effects and patient subsets, Biometrics, 41, 361-372.

Pan and Wolfe (1993), Tests for generalized problems of detecting
qualitative interaction, Technical Report No. 526, Department of Statistics,
The Ohio State University.

Pan and Wolfe (1997), Test for qualitative interaction of clinical
significance, Statistics in Medicine, 16, 1645-1652.
}
\seealso{
\code{\link{print.qualint}}, \code{\link{coef.qualint}}
}

