% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal_std_diff.R
\name{calc_std_diff}
\alias{calc_std_diff}
\title{Calculate standardized difference}
\usage{
calc_std_diff(vars, data0, weight0, data1, weight1)
}
\arguments{
\item{vars}{variables of interest. standardized difference of each variable \cr
listed here will be calculated.}

\item{data0}{A \code{data.frame} which include \code{vars} as columns from reference arm.
All data are expected to be numerical. If a column is
not numerical, it will be turned to numerical by \code{\link{model.matrix}}.}

\item{weight0}{weights for each record in reference arm.}

\item{data1}{A \code{data.frame} which include \code{vars} as columns from comparison arm.
All data are expected to be numerical. If a column is
not numerical, it will be turned to numerical by \code{\link{model.matrix}}.}

\item{weight1}{weights for each record in comparison arm.}
}
\value{
return a \code{numeric} vector for standardized difference of each variable
}
\description{
Calculate standardized difference
}
\note{
Calculation from Austin and Stuart (2015)
}
\examples{
library(dplyr)
data0 <- clinical \%>\% filter(ARM == "experimental")
data1 <- clinical \%>\% filter(ARM == "control")
calc_std_diff(
  vars = c("BECOG", "SEX"),
  data0 = data0,
  weight0 = rep(1, nrow(data0)),
  data1 = data1,
  weight1 = rep(1, nrow(data1))
 )
}
