% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbitSpatial_R.R
\docType{data}
\name{Katrina.raw}
\alias{Katrina.raw}
\title{New Orleans business recovery in the aftermath of Hurricane Katrina.}
\format{Katrina.raw is a data frame with 673 observations on the following 15 
variables:
\describe{
  \item{\code{code}}{a numeric vector}
  \item{\code{long}}{longitude coordinate of store}
  \item{\code{lat}}{latitude coordinate of store}
  \item{\code{street1}}{a numeric vector}
  \item{\code{medinc}}{median income}
  \item{\code{perinc}}{a numeric vector}
  \item{\code{elevation}}{a numeric vector}
  \item{\code{flood}}{flood depth (measured in feet)}
  \item{\code{owntype}}{type of store ownership: "sole proprietorship" vs. 
	"local chain" vs. "national chain"}
  \item{\code{sesstatus}}{socio-economic status of clientele (1-5): 1-2 = low #'		status customers, 3 = middle, 4-5 = high status customers}
  \item{\code{sizeemp}}{"small size" vs. "medium size" vs. "large size" 
  	firms}
  \item{\code{openstatus1}}{a numeric vector}
  \item{\code{openstatus2}}{a numeric vector}
  \item{\code{days}}{days to reopen business}
  \item{\code{street}}{1=Magazine Street, 2=Carrollton Avenue, 3=St. Claude 
  	Avenue}
}

Katrina is a data frame with 673 observations on the following 13 variables.
\describe{
  \item{\code{long}}{longitude coordinate of store}
  \item{\code{lat}}{latitude coordinate of store}
  \item{\code{flood_depth}}{flood depth (measured in feet)}
  \item{\code{log_medinc}}{log median income}
  \item{\code{small_size}}{binary variable for "small size" firms}
  \item{\code{large_size}}{binary variable for "large size" firms}
  \item{\code{low_status_customers}}{binary variable for low socio-economic 
	status of clientele}
  \item{\code{high_status_customers}}{binary variable for high socio-economic 
  	status of clientele}
  \item{\code{owntype_sole_proprietor}}{a binary variable indicating "sole 
	proprietor" ownership type}
  \item{\code{owntype_national_chain}}{a binary variable indicating 
	"national_chain" ownership type}
  \item{\code{y1}}{reopening status in the very short period 0-3 months; 
  	1=reopened, 0=not reopened}
  \item{\code{y2}}{reopening status in the period 0-6 months; 1=reopened, 
	0=not reopened}
  \item{\code{y3}}{reopening status in the period 0-12 months; 1=reopened, 
	0=not reopened}
}}
\source{
The raw data was obtained from the Royal Statistical Society dataset website 
\url{www.blackwellpublishing.com/rss/Volumes/Av174p4.htm} and brought 
to RData format by Wilhelm and Godinho de Matos (2013).
}
\usage{
data(Katrina)
}
\description{
This dataset has been used in the LeSage et al. (2011) paper entitled "New 
Orleans business recovery in the aftermath of Hurricane Katrina" to study 
the decisions of shop owners to reopen business after Hurricane Katrina. The 
dataset contains 673 observations on 3 streets in New Orleans and can be 
used to estimate the spatial probit models and to replicate the findings in 
the paper.
}
\details{
The Katrina.raw dataset contains the data found on the website before some 
of the variables are recoded. For example, the socio-economic status of 
clientele is coded as 1-5 in the raw data, but only 3 levels will be used in 
estimation: 1-2 = low status customers, 3 = middle, 4-5 = high status 
customers. Hence, with "middle" as the reference category, Katrina contains 
2 dummy variables for low status customers and high status customers.

The dataset Katrina is the result of these recoding operations and can be 
directly used for model estimation.
}
\note{
When definining the reopening status variables y1 (0-3 months), y2 (0-6 
months), and y3 (0-12 months) from the days variable, the Matlab code 
ignores the seven cases where days=90. To be consistent with the number of 
cases in the paper, we define y1,y2,y3 in the same way: y1=sum(days < 90), 
y2=sum(days < 180 & days != 90), y3=sum(days < 365 & days != 90). So this is 
not a bug, its a feature.
}
\keyword{datasets}

