% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outcode_reverse_geocoding.R
\name{outcode_reverse_geocoding}
\alias{outcode_reverse_geocoding}
\title{Outcode reverse geocoding}
\usage{
outcode_reverse_geocoding(longitude, latitude, limit = 10,
  radius = 5000)
}
\arguments{
\item{longitude}{A string, integer or float. Needs to have at least two decimal points.}

\item{latitude}{A string, integer or float. Needs to have at least two decimal points.}

\item{limit}{A string, integer or float. Limits number of postcodes matches to return. Defaults to 10. Needs to be less than 100.}

\item{radius}{A string, integer or float. Limits number of postcodes matches to return. Defaults to 5,000m. Needs to be less than 25,000m.}
}
\value{
A list of geographical properties.
}
\description{
Returns nearest outcodes for a given longitude and latitude.
}
\examples{
\donttest{
outcode_reverse_geocoding("-3.15", "51.47")
outcode_reverse_geocoding(-3.15, 51.47)
outcode_reverse_geocoding("-3.15807731271522", "51.4799900627036")
outcode_reverse_geocoding(-3.15, 51.47, limit = 11, radius = 20000)
}

}
\seealso{
\code{\link{postcode_lookup}} for documentation.
}
