% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dif_stats_Map.R
\name{Dif_Stats_Map}
\alias{Dif_Stats_Map}
\title{A function to map differentiation statistics.}
\usage{
Dif_Stats_Map(
  dat,
  pops,
  neighbors,
  countries,
  col,
  breaks = NULL,
  Lat_buffer,
  Long_buffer
)
}
\arguments{
\item{dat}{Data frame or character string that supplies the input data. If it is a character string, the file should be a csv. If it is a csv, the 1st row should contain the individual/population names. The columns should also be named in this fashion.}

\item{pops}{Data frame or character string that supplies the input data. If it is a character string, the file should be a csv. The columns should be named Sample, containing the sample IDs; Population indicating the population assignment of the individual; Long, indicating the longitude of the sample; Lat, indicating the latitude of the sample.}

\item{neighbors}{Numeric. The number of neighbors to plot connections with.}

\item{countries}{Character vector indicating the country borders that you wish to plot on a map. Can be any country that is valid in the ne_statest function in the rnaturalearth package.}

\item{col}{Character vector indicating the colors you wish to use for plotting.}

\item{breaks}{Numeric. The breaks used to generate the color ramp when plotting. Users should supply 3 values if custom breaks are desired.}

\item{Lat_buffer}{Numeric. A buffer to customize visualization.}

\item{Long_buffer}{Numeric. A buffer to customize visualization.}
}
\value{
A list containing the map and the matrix used to plot the map.
}
\description{
A function to map differentiation statistics.
}
\examples{
\donttest{
data(Fst_dat)
Fst <- Fst_dat[[1]]
Loc <- Fst_dat[[2]]
Test <- Dif_Stats_Map(dat = Fst, pops = Loc,
neighbors = 2, countries = c('united states of america', 'mexico'),
col = c('#fd8d3c','#fc4e2a','#e31a1c','#bd0026','#800026'),Lat_buffer = 1, Long_buffer = 1)}
}
