% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{allHaplotypes}
\alias{allHaplotypes}
\title{get all haplotypes for the given markers}
\usage{
allHaplotypes(mrknames)
}
\arguments{
\item{mrknames}{the names of the (bi-allelic) markers in the
haploblock (contig)}
}
\value{
a matrix with markers in columns and all possible (2 ^ nmrk)
haplotypes in rows. 0: haplotype contains the non-dosage-counted marker
allele (the reference allele); 1: haplotype contains the dosage-counted
(alternative) marker allele. The colnames are the marker names.
}
\description{
Given a set of bi-allelic (SNP) marker names, generate all
possible haplotypes
}
\examples{
# show the 8 possible haplotypes with 3 bi-allelic markers:
allHaplotypes(mrknames=c("mrkA", "mrkB", "mrkC"))
}
