% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdditionalCovariates.R
\name{createCohortCovariateSettings}
\alias{createCohortCovariateSettings}
\title{Extracts covariates based on cohorts}
\usage{
createCohortCovariateSettings(
  cohortName,
  settingId,
  cohortDatabaseSchema = NULL,
  cohortTable = NULL,
  cohortId,
  startDay = -30,
  endDay = 0,
  count = FALSE,
  ageInteraction = FALSE,
  lnAgeInteraction = FALSE,
  analysisId = 456
)
}
\arguments{
\item{cohortName}{Name for the cohort}

\item{settingId}{A unique id for the covariate time and}

\item{cohortDatabaseSchema}{The schema of the database with the cohort. If
nothing is specified then the cohortDatabaseSchema from databaseDetails at runtime is used.}

\item{cohortTable}{the table name that contains the covariate cohort. If
nothing is specified then the cohortTable from databaseDetails at runtime is used.}

\item{cohortId}{cohort id for the covariate cohort}

\item{startDay}{The number of days prior to index to start observing the cohort}

\item{endDay}{The number of days prior to index to stop observing the cohort}

\item{count}{If FALSE the covariate value is binary (1 means cohort occurred between index+startDay and index+endDay, 0 means it did not)
If TRUE then the covariate value is the number of unique cohort_start_dates between index+startDay and index+endDay}

\item{ageInteraction}{If TRUE multiple covariate value by the patient's age in years}

\item{lnAgeInteraction}{If TRUE multiple covariate value by the log of the patient's age in years}

\item{analysisId}{The analysisId for the covariate}
}
\value{
An object of class \code{covariateSettings} specifying how to create the cohort covariate with the covariateId
cohortId x 100000 + settingId x 1000 + analysisId
}
\description{
Extracts covariates based on cohorts
}
\details{
The user specifies a cohort and time period and then a covariate is constructed whether they are in the
cohort during the time periods relative to target population cohort index
}
\examples{
createCohortCovariateSettings(cohortName="testCohort",
                              settingId=1,
                              cohortId=1,
                              cohortDatabaseSchema="cohorts",
                              cohortTable="cohort_table")
}
