% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SaveLoadPlp.R
\name{loadPlpShareable}
\alias{loadPlpShareable}
\title{Loads the plp result saved as json/csv files for transparent sharing}
\usage{
loadPlpShareable(loadDirectory)
}
\arguments{
\item{loadDirectory}{The directory with the results as json/csv files}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{                             The runPlp object
}\if{html}{\out{</div>}}
}
\description{
Loads the plp result saved as json/csv files for transparent sharing
}
\details{
Load the main results from json/csv files into a runPlp object
}
\examples{
\donttest{ \dontshow{ # takes too long }
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n = 1000)
saveLoc <- file.path(tempdir(), "loadPlpShareable")
results <- runPlp(plpData, outcomeId = 3, saveDirectory = saveLoc)
savePlpShareable(results, saveLoc)
dir(saveLoc)
loadedResults <- loadPlpShareable(saveLoc)
# clean up
unlink(saveLoc, recursive = TRUE)
}
}
