% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PakPC2017KPK.R
\docType{data}
\name{PakPC2017KPK}
\alias{PakPC2017KPK}
\title{KPK Province data from Pakistan Population Census 2017}
\format{A \code{data.table} and  \code{data.frame} with 50 obs. of  12 variables.
\describe{
       \item{\code{Province}}{Province of Pakistan}
       \item{\code{Division}}{Division of Balochistan Province of Pakitan}
       \item{\code{District}}{District of Balochistan Province of Pakitan}
       \item{\code{ResStatus}}{Residental Status}
       \item{\code{Households}}{No. of Households}
       \item{\code{Male}}{Male Population}
       \item{\code{Female}}{Female Population}
       \item{\code{Transgender}}{Transgender Population}
       \item{\code{Pop2017}}{Total Population in 2017}
       \item{\code{Pop1998}}{Total Population in 1998}
       \item{\code{SexRatio2017}}{Sex Ration accoring to Pakistan Population Census 2017}
       \item{\code{GrowthRate}}{1998-2017 Average Annual Growth Rate}
       }}
\usage{
data(PakPC2017KPK)
}
\description{
\code{PakPC2017KPK} KPK Province data from Pakistan Population Census 2017.
}
\examples{
data(PakPC2017KPK)
library(data.table)
PakPC2017Res <- 
 c("Households", "Male", "Female", "Transgender", "Pop2017", "Pop1998")


PakPC2017KPK[
       , j        = lapply(.SD, sum, na.rm = TRUE) 
       , by       = .(Division, District)
       , .SDcols  = PakPC2017Res
       ][order(Division, District)]

}
\references{
\enumerate{
\item Pakistan Population Census 2017 (\url{http://www.pbscensus.gov.pk/}).
 }
}
\seealso{
, \code{\link{PakPC2017Balochistan}}
   \code{\link{PakPC2017City10}}
 , \code{\link{PakPC2017FATA}}
 , \code{\link{PakPC2017Islamabad}}
 , \code{\link{PakPC2017Pak}}
 , \code{\link{PakPC2017Pakistan}}
 , \code{\link{PakPC2017Punjab}}
 , \code{\link{PakPC2017Sindh}}
}
\author{
Muhammad Yaseen (\email{myaseen208@gmail.com})
}
\keyword{datasets}
