% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OMLDataSet_Class.R
\name{OMLDataSet}
\alias{OMLDataSet}
\alias{makeOMLDataSet}
\title{OMLDataSet.}
\usage{
makeOMLDataSet(desc, data, colnames.old = colnames(data),
  colnames.new = colnames(data), target.features)
}
\arguments{
\item{desc}{[\code{OMLDataSetDescription}]\cr
Data set description.}

\item{data}{[\code{data.frame}]\cr
The data set.}

\item{colnames.old}{[\code{character}]\cr
Names of the features that were uploaded to the server.}

\item{colnames.new}{[\code{character}]\cr
Names of the features that are displayed.}

\item{target.features}{[\code{character}]\cr
Name(s) of the target feature(s).}
}
\value{
[\code{OMLDataSet}]
}
\description{
An \code{OMLDataSet} consists of an \code{OMLDataSetDescription}, a
\code{data.frame} containing the data set, the old and new column names and,
finally, the target features.

The \code{\link{OMLDataSetDescription}} provides information on the data set,
like the ID, name, version, etc. To see a full list of all elements, please see the
\href{https://github.com/openml/website/blob/master/openml_OS/views/pages/api_new/v1/xsd/openml.data.upload.xsd}{XSD}.

The slot \code{colnames.old} contains the original names, i.e., the column names that were
uploaded to the server, while \code{colnames.new} contains the names that you will see when
working with the data in R.
Most of the time, old and new column names are identical. Only if the original names are
not valid, the new ones will differ.

The slot \code{target.features} contains the column name(s) from the \code{data.frame}
of the \code{OMLDataSet} that refer to the target feature(s).
}
\examples{
data("airquality")
dsc = "Daily air quality measurements in New York, May to September 1973.
This data is taken from R."
cit = "Chambers, J. M., Cleveland, W. S., Kleiner, B. and Tukey, P. A. (1983) Graphical
Methods for Data Analysis. Belmont, CA: Wadsworth."
desc_airquality = makeOMLDataSetDescription(name = "airquality",
  description = dsc,
  creator = "New York State Department of Conservation (ozone data) and the National
    Weather Service (meteorological data)",
  collection.date = "May 1, 1973 to September 30, 1973",
  language = "English",
  licence = "GPL-2",
  url = "https://stat.ethz.ch/R-manual/R-devel/library/datasets/html/00Index.html",
  default.target.attribute = "Ozone",
  citation = cit,
  tags = "R")

airquality_oml = makeOMLDataSet(desc = desc_airquality,
  data = airquality,
  colnames.old = colnames(airquality),
  colnames.new = colnames(airquality),
  target.features = "Ozone")
}
\seealso{
Other data set-related functions: \code{\link{OMLDataSetDescription}},
  \code{\link{convertMlrTaskToOMLDataSet}},
  \code{\link{convertOMLDataSetToMlr}},
  \code{\link{deleteOMLObject}},
  \code{\link{getOMLDataSet}},
  \code{\link{listOMLDataSets}},
  \code{\link{tagOMLObject}},
  \code{\link{uploadOMLDataSet}}
}

