% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warp_affine.R
\name{warpAffine}
\alias{warpAffine}
\title{Warp Affine}
\usage{
warpAffine(img, M, R, C, threads = 1, verbose = FALSE)
}
\arguments{
\item{img}{either a matrix or a 3-dimensional array with a range of values between 0 and 255}

\item{M}{a matrix corresponding to the transformation matrix}

\item{R}{a value corresponding to the destination number of rows}

\item{C}{a value corresponding to the destination number of columns}

\item{threads}{an integer specifying the number of threads to run in parallel. This parameter applies only if the input "img" parameter is of type matrix.}

\item{verbose}{a boolean. If TRUE then information will be printed in the console}
}
\value{
either a matrix or a 3-dimensional array
}
\description{
Warp Affine
}
\examples{

require(OpenImageR)

path = system.file("tmp_images", "landscape.jpg", package = "OpenImageR")
img = readImage(path)
img = img * 255

#.............................
# compute the affine transform
#.............................

r = ncol(img)
c = nrow(img)
offset = 50

original_points = matrix(data = c(0, 0, r, 0, 0, c),
                         nrow = 3,
                         ncol = 2,
                         byrow = TRUE)

transformed_points = matrix(data = c(offset, 0, r, offset, 0, c-offset),
                            nrow = 3,
                            ncol = 2,
                            byrow = TRUE)

M_aff = getAffineTransform(original_points = original_points,
                           transformed_points = transformed_points)

#..............
# 2-dimensional
#..............

img_2d = rgb_2gray(img)

res_2d = warpAffine(img = img_2d,
                    M = M_aff,
                    R = r,
                    C = c,
                    threads = 4,
                    verbose = TRUE)

# imageShow(res_2d)

#..............
# 3-dimensional
#..............

res_3d = warpAffine(img = img,
                    M = M_aff,
                    R = r,
                    C = c,
                    verbose = TRUE)

# imageShow(res_3d)

}
\references{
https://github.com/OlehOnyshchak/ImageTransformations/blob/master/AffineTransformation.ipynb
}
