% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VennPlot.R
\name{VennPlot}
\alias{VennPlot}
\title{Venn Diagram}
\usage{
VennPlot(lnames, group.labels = c("A", "B", "C"), saveplot = FALSE,
  savetype = c("png", "bmp", "jpeg", "tiff", "pdf"), plotname = "VennPlot",
  main = "Venn Diagram", cexval = 1, asp = 1, ...)
}
\arguments{
\item{lnames}{A list of up to three vectors, e.g. metabolite names.}

\item{group.labels}{A vector of reference values to be plotted, such as an
internal standard or sample weights.}

\item{saveplot}{A logical indication whether to save the plot produced.}

\item{savetype}{The required format for the plot to be saved in. Threre is a
choice of \code{"png","bmp","jpeg","tiff","pdf"} type files.}

\item{plotname}{Name of the output file if the file is to be saved. This is
the general name for all the graphs and the specific type prefix will be
added automatically.}

\item{main}{A title for the plot.}

\item{cexval}{The font size of the text labels.}

\item{asp}{The aspect ratio of the plot. A value of 1 produces a square plot
region.}

\item{...}{Other graphical parameters. See \code{\link[graphics]{par}}.}
}
\description{
Produces a Venn diagram showing the number of common metabolites.
}
\examples{
 
data("alldata_eg")
featuredata_eg<-alldata_eg$featuredata
dataview(featuredata_eg)
sampledata_eg<-alldata_eg$sampledata
dataview(sampledata_eg)
metabolitedata_eg<-alldata_eg$metabolitedata
dataview(metabolitedata_eg)

logdata <- LogTransform(featuredata_eg)
dataview(logdata$featuredata)
imp <-  MissingValues(logdata$featuredata,sampledata_eg,metabolitedata_eg,
                     feature.cutof=0.8, sample.cutoff=0.8, method="knn")
dataview(imp$featuredata)

#Linear model fit using unadjusted data
factormat<-model.matrix(~gender +Age +bmi, sampledata_eg)
unadjustedFit<-LinearModelFit(featuredata=imp$featuredata,
                             factormat=factormat,
                             ruv2=FALSE)
unadjustedFit

#Linear model fit using `is' normalized data 
Norm_is <-NormQcmets(imp$featuredata, method = "is", 
                    isvec = imp$featuredata[,which(metabolitedata_eg$IS ==1)[1]])
isFit<-LinearModelFit(featuredata=Norm_is$featuredata,
                     factormat=factormat,
                     ruv2=FALSE)
isFit

#Linear model fit with ruv-2 normalization
ruv2Fit<-LinearModelFit(featuredata=imp$featuredata,
                       factormat=factormat,
                       ruv2=TRUE,k=2,
                       qcmets = which(metabolitedata_eg$IS ==1))
ruv2Fit

lnames<- list(names(ruv2Fit$coef[,"Age"])[which(ruv2Fit$p.value[,"Age"]<0.05)],
             names(unadjustedFit$coef[,"Age"])[which(unadjustedFit$p.value[,"Age"]<0.05)],
             names(isFit$coef[,"Age"])[which(isFit$p.value[,"Age"]<0.05)])

VennPlot(lnames, group.labels=c("ruv2","unadjusted","is"))

}
\author{
Alysha M De Livera
}
