% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degree.R
\name{degree}
\alias{degree}
\title{Degree}
\usage{
degree(A)
}
\arguments{
\item{A}{An adjacency matrix of network data}
}
\value{
A vector of degree values for each node in the network.

If directed network, returns a list containing:

\item{inDegree}{Degree of incoming edges (pointing to the node)}

\item{outDegree}{Degree of outgoing edges (pointing away from the node)}

\item{relInf}{Relative degree of incoming and outgoing edges.
Positive values indicate more outgoing degree relative to incoming degree.
Negative values indicate more incoming degree relative to outgoing degree}
}
\description{
Computes degree of each node in a network
}
\examples{
#Undirected network
## Pearson's correlation only for CRAN checks
A <- TMFG(neoOpen, normal = FALSE)$A

deg <- degree(A)

#Directed network
\dontrun{
dep <- depend(neoOpen)

Adep <- TMFG(dep, depend = TRUE)$A

deg <- degree(Adep)
}

}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}, 1059-1069.
doi: \href{https://doi.org/10.1016/j.neuroimage.2009.10.003}{10.1016/j.neuroimage.2009.10.003}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
