% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold.R
\name{threshold}
\alias{threshold}
\title{Threshold Network Estimation Methods}
\usage{
threshold(data, a, thresh = c("alpha", "adaptive", "bonferroni", "FDR",
  "proportional"), normal = FALSE, na.data = c("pairwise", "listwise",
  "fiml", "none"), ...)
}
\arguments{
\item{data}{Can be a dataset or a correlation matrix}

\item{a}{When \code{thresh = "alpha"}, \code{"adaptive"}, and \code{"bonferroni"}
an \eqn{\alpha} threshold is applied (defaults to \code{.05}).
For \code{"adaptive"}, beta (Type II error) is set to \eqn{\alpha*5} for a medium effect size (\emph{r} = .3).
When \code{thresh = "FDR"}, a q-value threshold is applied (defaults to \code{.10}).
When \code{thresh = "proportional"}, a density threshold is applied (defaults to \code{.15})}

\item{thresh}{Sets threshold. Defaults to \code{"alpha"}.
Set to any value 0> \emph{r} >1 to retain values greater than set value,
\code{"adaptive"} for an \code{\link{adapt.a}} based on sample size (Perez & Pericchi, 2014),
\code{"bonferroni"} for the bonferroni correction on alpha,
\code{"FDR"} for local false discovery rate,
and \code{"proportional"} for a fixed density of edges (keeps strongest correlations within density)}

\item{normal}{Should data be transformed to a normal distribution?
Defaults to FALSE.
Data is not transformed to be normal.
Set to TRUE if data should be transformed to be normal
(computes correlations using the \link[qgraph]{cor_auto} function)}

\item{na.data}{How should missing data be handled?
For \code{"listwise"} deletion the \code{\link{na.omit}} function is applied.
Set to \code{"fiml"} for Full Information Maxmimum Likelihood (\code{\link[psych]{corFiml}}).
Full Information Maxmimum Likelihood is \strong{recommended} but time consuming}

\item{...}{Additional arguments for \code{\link[fdrtool]{fdrtool}} and \code{\link[NetworkToolbox]{adapt.a}}}
}
\value{
Returns a list containing:

\item{A}{The filtered adjacency matrix}

\item{r.cv}{The critical correlation value used to filter the network}
}
\description{
Filters the network based on an r-value, alpha, adaptive alpha,
bonferroni, false-discovery rate (FDR), or proportional density (fixed number of edges) value
}
\examples{
threshnet<-threshold(neoOpen)

alphanet<-threshold(neoOpen, thresh = "alpha", a = .05)

bonnet<-threshold(neoOpen, thresh = "bonferroni", a = .05)

FDRnet<-threshold(neoOpen, thresh = "FDR", a = .10)

propnet<-threshold(neoOpen, thresh = "proportional", a = .15)
}
\references{
Strimmer, K. (2008).
fdrtool: A versatile R package for estimating local and tail area-based false discovery rates.
\emph{Bioinformatics}, \emph{24}, 1461-1462.
doi: \href{https://doi.org/10.1093/bioinformatics/btn209}{10.1093/bioinformatics/btn209}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
