% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{PathLengths}
\alias{PathLengths}
\title{Characteristic Path Lengths}
\usage{
PathLengths(A, weighted = FALSE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{weighted}{Is the network weighted? Defaults to FALSE. Set to TRUE for weighted measures of ASPL, ASPLi, ecc, and D}
}
\value{
Returns a list of ASPL, ASPLi, ecc, and D of a network
}
\description{
Computes global average shortest path length (ASPL), local average shortest path length (ASPLi), eccentricity (ecc), and diameter (D) of a network (Weighted not coded)
}
\examples{
unweighted_PL<-PathLengths(A)

weighted_PL<-PathLengths(A,weighted=TRUE)
}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
Neuroimage, 52(3), 1059-1069.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
