% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.cascade}
\alias{plot.cascade}
\title{Plot a cascade object}
\usage{
\method{plot}{cascade}(x, label_nodes = TRUE, selection = NULL, ...)
}
\arguments{
\item{x}{object of class cascade to be plotted.}

\item{label_nodes}{logical, indicating if should the nodes in each cascade be 
labeled. If the cascades are very dense setting this to \code{FALSE} is
recommended.}

\item{selection}{a vector of cascade ids to plot.}

\item{...}{additional arguments passed to plot.}
}
\value{
A ggplot plot object.
}
\description{
Plot a cascade object
}
\examples{

data(cascades)
plot(cascades, selection = names(cascades$cascade_nodes)[1:5])
plot(cascades, label_nodes = FALSE)

}
