% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Extintions.R
\name{ExtinctionOrder}
\alias{ExtinctionOrder}
\title{Extinctions analysis from custom order}
\usage{
ExtinctionOrder(
  Network,
  Order,
  NetworkType = "Trophic",
  clust.method = "cluster_infomap",
  IS = 0,
  Rewiring = FALSE,
  RewiringDist,
  RewiringProb = 0.5,
  verbose = TRUE,
  RecalcConnect = FALSE
)
}
\arguments{
\item{Network}{a network representation as a an adjacency matrix, edgelist, or a network object}

\item{Order}{a numeric vector indexing order of primary extinctions. For Method = Mostconnected Order must be NULL. If Order is not NULL, Method is internally forced to be Ordered.}

\item{NetworkType}{a character with the options Trophic and Mutualistic - is used to calculate secondary extinctions.}

\item{clust.method}{a character with the options cluster_edge_betweenness,
cluster_label_prop or cluster_infomap, defaults to cluster_infomap}

\item{IS}{either numeric or a named vector of numerics. Identifies the threshold of relative interaction strength which species require to not be considered secondarily extinct (i.e. IS = 0.3 leads to removal of all nodes which lose 70percent of their interaction strength in the Network argument). If a named vector, names must correspond to vertex names in Network argument.}

\item{Rewiring}{either a function or a named vector of functions. Signifies how rewiring probabilities are calculated from the RewiringDist argument. If FALSE, no rewiring is carried out.}

\item{RewiringDist}{a numeric matrix of NxN dimension (N... number of nodes in Network). Contains, for example, phylogenetic or functional trait distances between nodes in Network which are used by the Rewiring argument to calculate rewiring probabilities. If Rewiring == function(x){x}, this matrix is expected to contain probabilities of a connection being present between species-pairs.}

\item{RewiringProb}{a numeric which identifies the threshold at which to assume rewiring potential is met.}

\item{verbose}{Logical. Whether to report on function progress or not.}

\item{RecalcConnect}{Logical. Whether to recalculate connectedness of each node following each round of extinction simulation and subsequently update extinction order with newly mostconnected nodes.}
}
\value{
exports list containing a data frame with the characteristics of the network after every extinction and a network object containing the final network. The resulting data frame contains 11 columns that incorporate the topological index, the secondary extinctions, predation release, and total extinctions of the network in each primary extinction.
}
\description{
This function takes a network and eliminates nodes using a custom order. Subsequently, secondary extinctions are tallied up. Secondary extinction severity can be targeted by manipulating the node-dependency on network edges (IS) and node-rewiring potential upon loss of links (Rewiring).
}
\details{
When NetworkType = Trophic, secondary extinctions only occur for any predator, but not producers. If NetworkType = Mutualistic, secondary extinctions occur for all species in the network.

When clust.method = cluster_edge_betweenness computes the network modularity using cluster_edge_betweenness methods from igraph to detect communities
When clust.method = cluster_label_prop computes the network modularity using cluster_label_prop methods from igraph to detect communities
When clust.method = cluster_infomap computes the network modularity using cluster_infomap methods from igraph to detect communities, here the number of nb.trials are equal to the network size
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>

M. Isidora Ávila-Thieme <msavila@uc.cl>

Erik Kusch <erik.kusch@bio.au.dk>
}
