% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nd_graphon.R
\name{nd.graphon}
\alias{nd.graphon}
\title{Graphon Estimates Distance}
\usage{
nd.graphon(
  A,
  out.dist = TRUE,
  method = c("completion", "LG", "nbdsmooth", "SBA", "USVT"),
  ...
)
}
\arguments{
\item{A}{a list of length \eqn{N} containing \eqn{(M\times M)} adjacency matrices.}

\item{out.dist}{a logical; \code{TRUE} for computed distance matrix as a \code{dist} object.}

\item{method}{type of graphon estimation methods to be used.}

\item{...}{extra parameters to be passed onto graphon estimation functions. See also \code{\link[graphon]{est.completion}},
\code{\link[graphon]{est.LG}}, \code{\link[graphon]{est.nbdsmooth}}, \code{\link[graphon]{est.SBA}}, and \code{\link[graphon]{est.USVT}} for details.}
}
\value{
a named list containing \describe{
\item{D}{an \eqn{(N\times N)} matrix or \code{dist} object containing pairwise distance measures.}
}
}
\description{
Graphon is a symmetric measurable function
\deqn{W:[0,1]^2\rightarrow[0,1]}
that is considered to be a generating model for an observed network. \code{nd.graphon} computes
distances between networks based on the estimated graphons of each network. Estimation methods
are taken from \pkg{graphon} package. For more details, see the function links below.
}
\examples{
## load example data
data(graph20)

## compute USVT-based distance
output <- nd.graphon(graph20, out.dist=FALSE, method="usvt")

## visualize
opar = par(no.readonly=TRUE)
par(pty="s")
image(output$D[,20:1], main="USVT", col=gray(0:32/32), axes=FALSE)
par(opar)

}
\references{
\insertRef{mukherjee_clustering_2017}{NetworkDistance}
}
