% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SlicecdGammaPareto.R
\name{ExposureCurveSlicedGammaPareto}
\alias{ExposureCurveSlicedGammaPareto}
\title{Exposure Curve from a Sliced Gamma Pareto severity distribution}
\usage{
ExposureCurveSlicedGammaPareto(x, GShape, GRate, SlicePoint, PShape)
}
\arguments{
\item{x}{A positive real number -  the claim amount where the exposure curve will be evaluated.}

\item{GShape}{A positive real number -  the shape parameter of the Claim Severity's Gamma distribution.}

\item{GRate}{A positive real number -  the rate parameter of the Claim Severity's Gamma distribution.}

\item{SlicePoint}{A positive real number - the slice point and the scale parameter of the Claim Severity's Pareto distribution.}

\item{PShape}{A positive real number - the shape parameter of the Claim Severity's Pareto distribution.}
}
\value{
The value of the Exposure curve at \code{x} with an attritional claim Gamma distribution with parameters \code{GShape} and \code{GRate} and a large claim Pareto distribution with parameters \code{SlicePoint} and \code{PShape}.
}
\description{
Exposure Curve from a Sliced Gamma Pareto severity distribution
}
\examples{
ExposureCurveSlicedGammaPareto(3000,1,0.0005,1000,1.2)
ExposureCurveSlicedGammaPareto(1000,1.1,0.0006,2000,1.6)
ExposureCurveSlicedGammaPareto(2000,1.2,0.0004,3000,1.4)
}
