% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{vCat}
\alias{vCat}
\title{Verbose Concatenate and Print with Indentation}
\usage{
vCat(verbose, ind = 0, ..., sep = " ", fill = TRUE, labels = NULL)
}
\arguments{
\item{verbose}{logical. If \code{TRUE}, passes the rest of the arguments to
\code{\link{cat}}}

\item{ind}{an integer corresponding to the level of indentation. Each
indentation level corresponds to two spaces.}

\item{...}{Arguments to pass to \code{\link[base]{cat}}}

\item{sep}{a character vector of strings to append after each element.}

\item{fill}{a logical or (positive) numeric controlling how the output is 
broken into successive lines. If \code{FALSE}, only newlines created 
explicitly by "\\n" are printed. Otherwise, the output is broken into lines
with print width equal to the option width if fill is \code{TRUE} 
(default), or the value of fill if this is numeric. Non-positive fill 
values are ignored, with a warning.}

\item{labels}{character vector of labels for the lines printed. Ignored if 
fill is \code{FALSE}.}
}
\description{
Concatenate and output the objects only if the \code{verbose} flag is set 
to \code{TRUE}. Allows for indentation, adding a series of spaces to the 
beginning of each line, 2 for every increment in \code{ind}.
}
\details{
\code{vCat} is slightly more intelligent than regulat \code{cat} in the way 
 it formats the output and breaks it into lines. As a result, \code{fill} is 
 set to \code{TRUE} by default. Another notable difference from \code{cat} is
 the way newline objects are handled. For example, the call: 
 \code{cat("hello", "world", "\\n", "foo", "bar")} won't wrap the newline 
 character with spaces. This avoids the need to set \code{sep} to \code{""} 
 and embed multiple \code{paste} calls. Finally, a newline character is 
 appended to the end of the whole message, avoiding the need to manually 
 specify this when calling \code{vCat}.
}
\seealso{
\code{\link[base]{cat}}
}

