# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Check whether there are any non-finite values in a matrix
#'
#' The C++ functions will not work with NA values, and the calculation of the
#' summary profile will take a long time to run before crashing.
#'
#' @param matPtr matrix to check.
#' 
#' @return
#'  Throws an error if any \code{NA}, \code{NaN}, \code{Inf}, or \code{-Inf}
#'  values are found, otherwise returns silently.
#' 
CheckFinite <- function(matPtr) {
    invisible(.Call('NetRep_CheckFinite', PACKAGE = 'NetRep', matPtr))
}

#' Calculate the intermediate network properties in the discovery dataset
#' 
#' These properties are need at every permutation: so they will be computed 
#' once.
#' 
#' @details
#' \subsection{Input expectations:}{
#'   Note that this function expects all inputs to be sensible, as checked by
#'   the R function 'checkUserInput' and processed by 'modulePreservation'. 
#'   
#'   These requirements are:
#'   \itemize{
#'   \item{The ordering of node names across 'dData', 'dCorr', and 'dNet' is
#'         consistent.}
#'   \item{The columns of 'dData' are the nodes.}
#'   \item{'dData' has been scaled by 'Scale'.}
#'   \item{'dCorr' and 'dNet'  are square matrices, and their rownames are 
#'         identical to their column names.}
#'   \item{'moduleAssigments' is a named character vector, where the names
#'         represent node labels found in the discovery dataset (e.g. 'dNet').}
#'   }
#' }
#' 
#' @param dData scaled data matrix from the \emph{discovery} dataset.
#' @param dCorr matrix of correlation coefficients between all pairs of 
#'   variables/nodes in the \emph{discovery} dataset.
#' @param dNet adjacency matrix of network edge weights between all pairs of 
#'   nodes in the \emph{discovery} dataset.
#' @param tNodeNames a character vector of node names in the test dataset
#' @param moduleAssignments a named character vector containing the module 
#'   each node belongs to in the discovery dataset. 
#' @param modules a character vector of modules for which to calculate the 
#'   module preservation statistics.
#' 
#' @return a list containing three lists: a list of weighted degree vectors,
#'   a list of correlation coefficient vectors, and a list of node 
#'   contribution vectors. There is one vector for each module in each list.
#'   
IntermediateProperties <- function(dData, dCorr, dNet, tNodeNames, moduleAssignments, modules) {
    .Call('NetRep_IntermediateProperties', PACKAGE = 'NetRep', dData, dCorr, dNet, tNodeNames, moduleAssignments, modules)
}

#' Calculate the intermediate network properties in the discovery dataset
#' 
#' These properties are need at every permutation: so they will be computed 
#' once.
#' 
#' @details
#' \subsection{Input expectations:}{
#'   Note that this function expects all inputs to be sensible, as checked by
#'   the R function 'checkUserInput' and processed by 'modulePreservation'. 
#'   
#'   These requirements are:
#'   \itemize{
#'   \item{The ordering of node names across 'dCorr' and 'dNet' is
#'         consistent.}
#'   \item{'dCorr' and 'dNet'  are square matrices, and their rownames are 
#'         identical to their column names.}
#'   \item{'moduleAssigments' is a named character vector, where the names
#'         represent node labels found in the discovery dataset (e.g. 'dNet').}
#'   }
#' }
#' 
#' @param dCorr matrix of correlation coefficients between all pairs of 
#'   variables/nodes in the \emph{discovery} dataset.
#' @param dNet adjacency matrix of network edge weights between all pairs of 
#'   nodes in the \emph{discovery} dataset.
#' @param tNodeNames a character vector of node names in the test dataset
#' @param moduleAssignments a named character vector containing the module 
#'   each node belongs to in the discovery dataset. 
#' @param modules a character vector of modules for which to calculate the 
#'   module preservation statistics.
#' 
#' @return a list containing two lists: a list of weighted degree vectors,
#'   and a list of correlation coefficient vectors. There is one vector for 
#'   each module in each list.
#'   
IntermediatePropertiesNoData <- function(dCorr, dNet, tNodeNames, moduleAssignments, modules) {
    .Call('NetRep_IntermediatePropertiesNoData', PACKAGE = 'NetRep', dCorr, dNet, tNodeNames, moduleAssignments, modules)
}

#' Multithreaded permutation procedure for module preservation statistics
#' 
#' @details
#' \subsection{Input expectations:}{
#'   Note that this function expects all inputs to be sensible, as checked by
#'   the R function 'checkUserInput' and processed by 'modulePreservation'. 
#'   
#'   These requirements are:
#'   \itemize{
#'   \item{The ordering of node names across 'tData', 'tCorr', and 'tNet' is
#'         consistent.}
#'   \item{The columns of 'tData' are the nodes.}
#'   \item{'tData' has been scaled by 'Scale'.}
#'   \item{'tCorr' and 'tNet' are square matrices, and their rownames are 
#'         identical to their column names.}
#'   \item{'moduleAssigments' is a named character vector, where the names
#'         represent node labels found in the discovery dataset (e.g. 'dNet').}
#'   \item{'nPermutations' is a single number, greater than 0.}
#'   \item{'nCores' is a single number, greater than 0. Note, this number must
#'         not be larger than the number of cores on your machine, or the 
#'         number of cores allocated to your job!}
#'   \item{'nullHypothesis' must be a character vector of length 1, containing
#'         either "overlap" or "all".}
#'   \item{'verbose' must be a logical vector of length 1 containing either 
#'         'TRUE' or 'FALSE'.}
#'   \item{'vCat' must be the function NetRep:::vCat.}
#'   }
#' }
#' 
#' @param discProps a list of intermediate properties calculated in the 
#'   discovery dataset by \code{\link{IntermediateProperties}}.
#' @param tData scaled data matrix from the \emph{test} dataset.
#' @param tCorr matrix of correlation coefficients between all pairs of 
#'   variables/nodes in the \emph{test} dataset.
#' @param tNet adjacency matrix of network edge weights between all pairs of 
#'   nodes in the \emph{test} dataset.
#' @param moduleAssignments a named character vector containing the module 
#'   each node belongs to in the discovery dataset. 
#' @param modules a character vector of modules for which to calculate the 
#'   module preservation statistics.
#' @param nPermutations the number of permutations from which to generate the
#'   null distributions for each statistic.
#' @param nCores the number of cores that the permutation procedure may use.
#' @param nullHypothesis either "overlap" or "all".
#' @param verbose if 'true', then progress messages are printed.
#' @param vCat the vCat function must be passed in so that it can be called 
#'  for output logging. 
#' 
#' @return a list containing a matrix of observed test statistics, and an
#'   array of null distribution observations.
PermutationProcedure <- function(discProps, tData, tCorr, tNet, moduleAssignments, modules, nPermutations, nCores, nullHypothesis, verbose, vCat) {
    .Call('NetRep_PermutationProcedure', PACKAGE = 'NetRep', discProps, tData, tCorr, tNet, moduleAssignments, modules, nPermutations, nCores, nullHypothesis, verbose, vCat)
}

#' Multithreaded permutation procedure for module preservation statistics
#' 
#' @details
#' \subsection{Input expectations:}{
#'   Note that this function expects all inputs to be sensible, as checked by
#'   the R function 'checkUserInput' and processed by 'modulePreservation'. 
#'   
#'   These requirements are:
#'   \itemize{
#'   \item{The ordering of node names across 'tCorr' and 'tNet' is consistent.}
#'   \item{'tCorr' and 'tNet' are square matrices, and their rownames are 
#'         identical to their column names.}
#'   \item{'moduleAssigments' is a named character vector, where the names
#'         represent node labels found in the discovery dataset (e.g. 'dNet').}
#'   \item{'nPermutations' is a single number, greater than 0.}
#'   \item{'nCores' is a single number, greater than 0. Note, this number must
#'         not be larger than the number of cores on your machine, or the 
#'         number of cores allocated to your job!}
#'   \item{'nullHypothesis' must be a character vector of length 1, containing
#'         either "overlap" or "all".}
#'   \item{'verbose' must be a logical vector of length 1 containing either 
#'         'TRUE' or 'FALSE'.}
#'   \item{'vCat' must be the function NetRep:::vCat.}
#'   }
#' }
#' 
#' @param discProps a list of intermediate properties calculated in the 
#'   discovery dataset by \code{\link{IntermediatePropertiesNoData}}.
#' @param tCorr matrix of correlation coefficients between all pairs of 
#'   variables/nodes in the \emph{test} dataset.
#' @param tNet adjacency matrix of network edge weights between all pairs of 
#'   nodes in the \emph{test} dataset.
#' @param moduleAssignments a named character vector containing the module 
#'   each node belongs to in the discovery dataset. 
#' @param modules a character vector of modules for which to calculate the 
#'   module preservation statistics.
#' @param nPermutations the number of permutations from which to generate the
#'   null distributions for each statistic.
#' @param nCores the number of cores that the permutation procedure may use.
#' @param nullHypothesis either "overlap" or "all".
#' @param verbose if 'true', then progress messages are printed.
#' @param vCat the vCat function must be passed in so that it can be called 
#'  for output logging. 
#' 
#' @return a list containing a matrix of observed test statistics, and an
#'   array of null distribution observations.
PermutationProcedureNoData <- function(discProps, tCorr, tNet, moduleAssignments, modules, nPermutations, nCores, nullHypothesis, verbose, vCat) {
    .Call('NetRep_PermutationProcedureNoData', PACKAGE = 'NetRep', discProps, tCorr, tNet, moduleAssignments, modules, nPermutations, nCores, nullHypothesis, verbose, vCat)
}

#' Calculate the network properties 
#' 
#' @details
#' \subsection{Input expectations:}{
#'   Note that this function expects all inputs to be sensible, as checked by
#'   the R function 'checkUserInput' and processed by 'networkProperties'. 
#'   
#'   These requirements are:
#'   \itemize{
#'   \item{The ordering of node names across 'data' and 'net' is consistent.}
#'   \item{The columns of 'data' are the nodes.}
#'   \item{'net' is a square matrix, and its rownames are identical to its 
#'         column names.}
#'   \item{'moduleAssigments' is a named character vector, where the names
#'         represent node labels found in the discovery dataset. Unlike 
#'         'PermutationProcedure', these may include nodes that are not 
#'         present in 'data' and 'net'.}
#'   \item{The module labels specified in 'modules' must occur in 
#'         'moduleAssignments'.}
#'   }
#' }
#' 
#' @param data data matrix from the dataset in which to calculate the network
#'   properties.
#' @param net adjacency matrix of network edge weights between all pairs of 
#'   nodes in the dataset in which to calculate the network properties.
#' @param moduleAssignments a named character vector containing the module 
#'   each node belongs to in the discovery dataset. 
#' @param modules a character vector of modules for which to calculate the 
#'   network properties for.
#' 
#' @return a list containing the summary profile, node contribution, module
#'   coherence, weighted degree, and average edge weight for each 'module'.
NetProps <- function(data, net, moduleAssignments, modules) {
    .Call('NetRep_NetProps', PACKAGE = 'NetRep', data, net, moduleAssignments, modules)
}

#' Calculate the network properties, data matrix not provided
#' 
#' @details
#' \subsection{Input expectations:}{
#'   Note that this function expects all inputs to be sensible, as checked by
#'   the R function 'checkUserInput' and processed by 'networkProperties'. 
#'   
#'   These requirements are:
#'   \itemize{
#'   \item{'net' is a square matrix, and its rownames are identical to its 
#'         column names.}
#'   \item{'moduleAssigments' is a named character vector, where the names
#'         represent node labels found in the discovery dataset. Unlike 
#'         'PermutationProcedure', these may include nodes that are not 
#'         present in 'data' and 'net'.}
#'   \item{The module labels specified in 'modules' must occur in 
#'         'moduleAssignments'.}
#'   }
#' }
#' 
#' @param net adjacency matrix of network edge weights between all pairs of 
#'   nodes in the dataset in which to calculate the network properties.
#' @param moduleAssignments a named character vector containing the module 
#'   each node belongs to in the discovery dataset. 
#' @param modules a character vector of modules for which to calculate the 
#'   network properties for.
#' 
#' @return a list containing the summary profile, node contribution, module
#'   coherence, weighted degree, and average edge weight for each 'module'.
NetPropsNoData <- function(net, moduleAssignments, modules) {
    .Call('NetRep_NetPropsNoData', PACKAGE = 'NetRep', net, moduleAssignments, modules)
}

#' Scale data across all nodes
#' 
#' Each node is centered by its mean and scaled by it standard deviation.
#' 
#' @param data matrix to scale.
#' 
#' @return
#'  A scaled data matrix.
#'
Scale <- function(data) {
    .Call('NetRep_Scale', PACKAGE = 'NetRep', data)
}

