% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patch-functions.R
\docType{methods}
\name{patchSet}
\alias{patchSet}
\alias{patchSet,matrix-method}
\title{\code{Patch} set}
\usage{
patchSet(...)

\S4method{patchSet}{matrix}(...)
}
\arguments{
\item{...}{Matrices (\code{ncol} = 2) of \code{patches} coordinates with the first column
\code{pxcor} and the second column \code{pycor}.}
}
\value{
Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second column
        \code{pycor} representing the \code{patches} coordinates.
}
\description{
Report the \code{patch} coordinates of all the unique \code{patches} contained in the inputs.
}
\details{
Duplicate \code{patches} among the inputs are removed in the returned matrix.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9)
p1 <- patchAt(world = w1, agents = patch(w1, c(0,1,2), c(0,0,0)), dx = 1, dy = 1)
p2 <- patchDistDir(world = w1, agents = patch(w1, 0, 0), dist = 1, angle = 45)
p3 <- patch(world = w1, x = 4.3, y = 8)
p4 <- patchSet(p1, p2, p3)


}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#patch-set}
}
\author{
Sarah Bauduin
}
