% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{tExist}
\alias{tExist}
\alias{tExist,agentMatrix,numeric,missing-method}
\alias{tExist,agentMatrix,numeric,character-method}
\title{Do the \code{turtle} exist?}
\usage{
tExist(turtles, who, breed)

\S4method{tExist}{agentMatrix,numeric,missing}(turtles, who)

\S4method{tExist}{agentMatrix,numeric,character}(turtles, who, breed)
}
\arguments{
\item{turtles}{\code{AgentMatrix} object representing the moving \code{agents}.}

\item{who}{Integer. Vector of the \code{who} numbers for the selected \code{turtles}.}

\item{breed}{Characters. Vector of \code{breed} names for the selected \code{turtles}.
If missing, there is no distinction based upon \code{breed}.}
}
\value{
Logical. Vector of \code{TRUE} or \code{FALSE} if the \code{who} numbers
with any of the \code{breed}, if provided, exist or not
inside the \code{turtles}.
}
\description{
Report \code{TRUE} if a \code{turtle} exists inside the \code{turtles}, report
\code{FALSE} otherwise.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9)
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10),
                    breed = c(rep("sheep", 5), rep("wolf", 5)))
tExist(turtles = t1, who = 3, breed = "sheep")
tExist(turtles = t1, who = 9, breed = "sheep")
tExist(turtles = t1, who = 9, breed = c("sheep", "wolf"))
tExist(turtles = t1, who = c(3, 9))


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#member}
}
\author{
Sarah Bauduin
}
