% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentset-functions.R
\docType{methods}
\name{isNLclass}
\alias{isNLclass}
\alias{isNLclass,matrix,character-method}
\title{Type of object}
\usage{
isNLclass(agents, class)

\S4method{isNLclass}{matrix,character}(agents, class)
}
\arguments{
\item{agents}{Matrix (ncol = 2) with the first column "pxcor" and the second
              column "pycor" representing the patches coordinates, or

              AgentMatrix object representing the moving agents.}

\item{class}{Character. Can take one of the following options to define
the \code{class}: \code{"agent"}, \code{"agentset"},
\code{"patch"}, \code{"patchset"}. \code{"turtle"} or \code{"turtleset"}.}
}
\value{
Logical. \code{TRUE} if \code{agents} is of the \code{class} tested.
}
\description{
Report \code{TRUE} if the \code{agents} is of the \code{class} tested,
report \code{FALSE} otherwise.
}
\details{
Careful! The \code{class} tested does not correspond to actual R classes.

         \code{agents} is \code{"patch"} if it is a matrix (ncol = 2) with the
         first column "pxcor" and the second column "pycor" with only
         one row. \code{agents} is \code{"patcheset"} if the matrix has more than
         one row.

         \code{agents} is \code{"turtle"} if it is an agentMatrix
         containing only one turtle.
         \code{agents} is \code{"turtleset"} if the
         agentMatrix contains more than one turtle.

         \code{agents} is \code{"agent"} if it is either \code{"patch"} or
         \code{"turtle"}. \code{agents} is \code{"agentset"} if it is either
         \code{"patcheset"} or \code{"turtleset"}.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4)
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10),
                    heading = sample(1:3, size = 10, replace= TRUE))
isNLclass(agents = patches(w1), class = "patch")
isNLclass(agents = patches(w1), class = "patcheset")
isNLclass(agents = t1, class = "agentset")
isNLclass(agents = t1, class = "turtleset")


}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#is-of-type}
}
\author{
Sarah Bauduin
}
