% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\docType{methods}
\name{canMove}
\alias{canMove}
\alias{canMove,worldNLR,agentMatrix,numeric-method}
\title{Can the turtles move?}
\usage{
canMove(world, turtles, dist)

\S4method{canMove}{worldNLR,agentMatrix,numeric}(world, turtles, dist)
}
\arguments{
\item{world}{WorldMatrix or worldArray object.}

\item{turtles}{AgentMatrix object representing the moving agents.}

\item{dist}{Numeric. Vector of distances to move. Must
be of length 1 or of length \code{turtles}.}
}
\value{
Logical. Vector of length \code{turtles}.
}
\description{
Report \code{TRUE} if a turtle can move the given distance without leaving
the \code{world}'s extent, report \code{FALSE} otherwise.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4)
t1 <- createTurtles(n = 10, world = w1)
canMove(world = w1, turtles = t1, dist = 1:10)


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#can-move}
}
\author{
Sarah Bauduin
}
