% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation.r
\name{VarianceSkew}
\alias{VarianceSkew}
\title{Asymptotic Variance of the estimated skewness vector}
\usage{
VarianceSkew(cum)
}
\arguments{
\item{cum}{The theoretical/estimated cumulants up to order 6 in vector form}
}
\value{
The matrix of theoretical/estimated variance
}
\description{
Asymptotic Variance of the estimated skewness vector
}
\examples{
alpha<-c(10,5)
omega<-diag(rep(1,2))
MC <- MomCumSkewNorm(r = 6,omega,alpha)
cum <- MC$CumX
VS <- VarianceSkew(cum)
}
\references{
Gy.Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021. Ch.6, formula (6.13)
}
\seealso{
Other Estimation: 
\code{\link{SampleEVSK}()},
\code{\link{SampleKurt}()},
\code{\link{SampleMomCum}()},
\code{\link{SampleSkew}()},
\code{\link{VarianceKurt}()}
}
\concept{Estimation}
