% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Commutators.R
\name{indx_Symmetry}
\alias{indx_Symmetry}
\title{Symmetrizing vector}
\usage{
indx_Symmetry(x, d, n)
}
\arguments{
\item{x}{the vector  to be symmetrized of dimension d^n}

\item{d}{size of the single vectors in the product}

\item{n}{power of the T-product}
}
\value{
A vector with the symmetrized version of x of dimension d^n
}
\description{
Vector symmetrizing a T-product of vectors of the same dimension d.
Produces the same results as matr_Symmetry
}
\examples{
a<-c(1,2)
b<-c(2,3)
c<-kronecker(kronecker(a,a),b)
## The symmetrized version of c is
indx_Symmetry(c,2,3)


}
\references{
Gy. Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021.Section 1.3.1 Symmetrization, p.14. (1.29)
}
\seealso{
Other Matrices and commutators: 
\code{\link{indx_Commutator_Kmn}()},
\code{\link{indx_Commutator_Kperm}()},
\code{\link{indx_Elimination}()},
\code{\link{indx_Qplication}()},
\code{\link{indx_UnivMomCum}()},
\code{\link{matr_Commutator_Kmn}()},
\code{\link{matr_Commutator_Kperm}()},
\code{\link{matr_Commutator_Mixing}()},
\code{\link{matr_Commutator_Moment}()},
\code{\link{matr_Elimination}()},
\code{\link{matr_Qplication}()},
\code{\link{matr_Symmetry}()}
}
\concept{Matrices and commutators}
