% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MomCums.r
\name{conv_Cum2MomMulti}
\alias{conv_Cum2MomMulti}
\title{Convert T-cumulants to T-moments   (multivariate)}
\usage{
conv_Cum2MomMulti(cum)
}
\arguments{
\item{cum}{the list of r d-variate cumulants in vector form starting from the first cumulant -
the vector of means - and arriving to the r-th order d-variate cumulant in vector form}
}
\value{
\code{Mom}  the list of r vectors of d-variate moments
}
\description{
Obtains a vector of d-variate moments from a vector of
d-variate cumulants
}
\examples{
#cum contains the  T-vector cumulants up to the fifth order of the bivariate
#standard normal distribution
cum<-list(c(0,0),c(1,0,0,1),c(0,0,0,0,0,0,0,0),c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
c(rep(0,32)))
conv_Cum2MomMulti(cum)

}
\references{
Gy. Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021.  Section 3.4 formula 3.40
}
\seealso{
Other Moments and cumulants: 
\code{\link{conv_Cum2Mom}()},
\code{\link{conv_Mom2CumMulti}()},
\code{\link{conv_Mom2Cum}()}
}
\concept{Moments and cumulants}
