% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hermite.r
\name{Hermite_Poly_NH_Inv}
\alias{Hermite_Poly_NH_Inv}
\title{Inverse univariate Hermite polynomial}
\usage{
Hermite_Poly_NH_Inv(H_N_x, sigma2 = 1)
}
\arguments{
\item{H_N_x}{The vector of Hermite Polynomials from 1 to N evaluated at x}

\item{sigma2}{The variance, by  default is set to 1}
}
\value{
The vector of x powers: \eqn{x^n}, \eqn{n=1:N}
}
\description{
Inverse univariate Hermite polynomial
}
\references{
Gy.Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021.  Section 4.4, (4.23), p.198
}
\seealso{
Other Hermite: 
\code{\link{Hermite_CoeffMulti}()},
\code{\link{Hermite_Coeff}()},
\code{\link{Hermite_N_Cov_X1_X2}()},
\code{\link{Hermite_Nth}()},
\code{\link{Hermite_Poly_HN_Multi}()},
\code{\link{Hermite_Poly_HN}()},
\code{\link{Hermite_Poly_NH_Multi_Inv}()}
}
\concept{Hermite}
