% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mplus.R
\name{mplusObject}
\alias{mplusObject}
\title{Create an Mplus model object}
\usage{
mplusObject(
  TITLE = NULL,
  DATA = NULL,
  VARIABLE = NULL,
  DEFINE = NULL,
  MONTECARLO = NULL,
  MODELPOPULATION = NULL,
  MODELMISSING = NULL,
  ANALYSIS = NULL,
  MODEL = NULL,
  MODELINDIRECT = NULL,
  MODELCONSTRAINT = NULL,
  MODELTEST = NULL,
  MODELPRIORS = NULL,
  OUTPUT = NULL,
  SAVEDATA = NULL,
  PLOT = NULL,
  usevariables = NULL,
  rdata = NULL,
  autov = TRUE,
  imputed = FALSE
)
}
\arguments{
\item{TITLE}{A character string of the title for Mplus.}

\item{DATA}{A charater string of the data section for Mplus (note, do not define
the filename as this is generated automatically)}

\item{VARIABLE}{A character string of the variable section for Mplus (note, do not
define the variable names from the dataset as this is generated automatically)}

\item{DEFINE}{A character string of the define section for Mplus (optional)}

\item{MONTECARLO}{A character string of the montecarlo section for Mplus (optional).
If used, \code{autov} is defaults to \code{FALSE} instead of the usual default,
\code{TRUE}, but may still be overwritten, if desired.}

\item{MODELPOPULATION}{A character string of the MODEL POPULATION section for Mplus (optional).}

\item{MODELMISSING}{A character string of the MODEL MISSING section for Mplus (optional).}

\item{ANALYSIS}{A character string of the analysis section for Mplus (optional)}

\item{MODEL}{A character string of the model section for Mplus (optional, although
typically you want to define a model)}

\item{MODELINDIRECT}{A character string of the MODEL INDIRECT section for Mplus (optional).}

\item{MODELCONSTRAINT}{A character string of the MODEL CONSTRAINT section for Mplus (optional).}

\item{MODELTEST}{A character string of the MODEL TEST section for Mplus (optional).}

\item{MODELPRIORS}{A character string of the MODEL PRIORS section for Mplus (optional).}

\item{OUTPUT}{A character string of the output section for Mplus (optional)}

\item{SAVEDATA}{A character string of the savedata section for Mplus (optional)}

\item{PLOT}{A character string of the plot section for Mplus (optional)}

\item{usevariables}{A character vector of the variables from the
\code{R} dataset to use in the model.}

\item{rdata}{An \code{R} dataset to be used for the model.}

\item{autov}{A logical (defaults to \code{TRUE}) argument indicating
whether R should attempt to guess the correct variables to use from
the R dataset, if \code{usevariables} is left \code{NULL}.}

\item{imputed}{A logical whether the data are multiply imputed (a list).
Defaults to \code{FALSE}.}
}
\value{
A list of class \code{mplusObject} with elements
\item{TITLE}{The title in Mplus (if defined)}
\item{DATA}{The data section in Mplus (if defined)}
\item{VARIABLE}{The variable section in Mplus (if defined)}
\item{DEFINE}{The define section in Mplus (if defined)}
\item{MONTECARLO}{The montecarlo section in Mplus (if defined)}
\item{MODELPOPULATION}{The modelpopulation section in Mplus (if defined)}
\item{MODELMISSING}{The modelmissing section in Mplus (if defined)}
\item{ANALYSIS}{The analysis section in Mplus (if defined)}
\item{MODEL}{The model section in Mplus (if defined)}
\item{MODELINDIRECT}{The modelindirect section in Mplus (if defined)}
\item{MODELCONSTRAINT}{The modelconstraint section in Mplus (if defined)}
\item{MODELTEST}{The modeltest section in Mplus (if defined)}
\item{MODELPRIORS}{The modelpriors section in Mplus (if defined)}
\item{OUTPUT}{The output section in Mplus (if defined)}
\item{SAVEDATA}{The savedata section in Mplus (if defined)}
\item{PLOT}{The plot section in Mplus (if defined)}
\item{results}{NULL by default, but can be later updated to include the results from the model run.}
\item{usevariables}{A character vector of the variables from the \code{R} data set to be used.}
\item{rdata}{The \code{R} data set to use for the model.}
\item{imputed}{A logical whether the data are multiply imputed.}
\item{autov}{A logical whether the data should have the usevariables detected automatically or not}
}
\description{
This is a function to create an Mplus model object in \code{R}.
The object holds all the sections of an Mplus input file, plus some
extra \code{R} ones. Once created, the model can be run using other
functions such as \code{mplusModeler} or updated using methods defined
for the \code{update} function.
}
\details{
Mplus model objects  allow a base model to be defined,
and then flexibly update the data, change the precise model, etc. If a section
does not vary between models, you can leave it the same. For example, suppose
you are fitting a number of models, but in all cases, wish to use maximum likelihood
estimator, \dQuote{ANALYSIS: ESTIMATOR = ML;} and would like standardized output,
\dQuote{OUTPUT: STDYX;}. Rather than retype those in every model, they can be defined
in one Mplus model object, and then that can simply be updated with different models,
leaving the analysis and output sections untouched. This also means that if a reviewer
comes back and asks for all analyses to be re-run say using the robust maximum likelihood
estimator, all you have to do is change it in the model object once, and re run all your code.
}
\examples{

example1 <- mplusObject(MODEL = "mpg ON wt;",
  usevariables = c("mpg", "hp"), rdata = mtcars)
str(example1)
rm(example1)

# R figures out the variables automagically, with a message
example2 <- mplusObject(MODEL = "mpg ON wt;",
  rdata = mtcars, autov = TRUE)
str(example2)
rm(example2)

# R can also try to figure out a list of variables when
# variable names are hyphenated first-last variable, all variables
# between the first and last one will be included
example3 <- mplusObject(MODEL = "mpg ON wt-vs;",
  rdata = mtcars, autov = TRUE)
str(example3)
rm(example3)

# R warns if the first 8 characters of a (used) variable name are not unique
# as they will be indistinguishable in the Mplus output
example4 <- mplusObject(MODEL = "basename_01 ON basename_02;",
  rdata = data.frame(basename_01 = 1:5, basename_02 = 5:1),
  autov = TRUE)
rm(example4)
}
\seealso{
\code{\link{mplusModeler}}
}
\author{
Joshua F. Wiley <jwiley.psych@gmail.com>
}
\keyword{interface}
